/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import org.jtester.module.tracer.jdbc.LexicalAnalysisProcessor;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracerSQLUtility {
    public static final String[] SQL_KEY_WORDS = new String[]{"select", "from", "update", "delete", "insert", "into", "where", "group", "by", "having", "values", "and", "or", "(", ")", "as", "like", "not", "in", "exists", "order", "asc", "desc", "on", "join", "outer", "set", "create", "table", "alter", "drop", "index"};
    private static String keywordLightPrefix = "<font color='#000080'><b>";
    private static String keywordLightSuffix = "</b></font>";
    private static String tablesLightPrefix = "<font color='#3F7F5F'><b>";
    private static String tablesLightSuffix = "</b></font>";

    public static Collection<String> analyseSqlTables(String sql) {
        String[] words = TracerSQLUtility.splitWord(sql, null);
        ArrayList<String> tables = new ArrayList<String>();
        TracerSQLUtility.tableAnalyse(new Counter(), words, tables);
        return tables;
    }

    public static String highlightKeywords(String sql) {
        String lightSql = TracerSQLUtility.replaceSql(sql, null, true);
        return lightSql;
    }

    public static String highlightSql(String sql) {
        Collection<String> tables = TracerSQLUtility.analyseSqlTables(sql);
        String lightSql = TracerSQLUtility.replaceSql(sql, tables, true);
        return lightSql;
    }

    private static String replaceSql(String sql, final Collection<String> tables, final boolean replaceKeyword) {
        final StringBuffer replacement = new StringBuffer(" ");
        LexicalAnalysisProcessor processor = new LexicalAnalysisProcessor(){

            public void process(String word) {
                int placeType = 0;
                if (replaceKeyword) {
                    for (int i = 0; i < SQL_KEY_WORDS.length; ++i) {
                        if (!SQL_KEY_WORDS[i].equals(word.toLowerCase())) continue;
                        placeType = 1;
                        break;
                    }
                }
                if (tables != null && tables.contains(word)) {
                    placeType = 2;
                }
                switch (placeType) {
                    case 0: {
                        replacement.append(word + " ");
                        break;
                    }
                    case 1: {
                        replacement.append(keywordLightPrefix + word + keywordLightSuffix + " ");
                        break;
                    }
                    case 2: {
                        replacement.append(tablesLightPrefix + word + tablesLightSuffix + " ");
                        break;
                    }
                }
            }
        };
        TracerSQLUtility.splitWord(sql, processor);
        return replacement.toString();
    }

    private static void tableAnalyse(Counter i, String[] words, Collection<String> tables) {
        while (i.num < words.length) {
            if ("(".equals(words[i.num].trim().toLowerCase())) {
                ++i.num;
                TracerSQLUtility.tableAnalyse(i, words, tables);
            } else {
                if (")".equals(words[i.num].trim().toLowerCase())) {
                    return;
                }
                if ("from".equals(words[i.num].trim().toLowerCase())) {
                    ++i.num;
                    while (i.num < words.length) {
                        String fromNext = words[i.num];
                        if ("(".equals(fromNext.trim().toLowerCase())) {
                            ++i.num;
                            TracerSQLUtility.tableAnalyse(i, words, tables);
                        } else {
                            if (")".equals(fromNext.trim().toLowerCase())) {
                                return;
                            }
                            if ("where".equals(fromNext.trim().toLowerCase()) || "into".equals(fromNext.trim().toLowerCase())) break;
                            if (!",".equals(fromNext.trim()) && ("from".equals(words[i.num - 1]) || ",".equals(words[i.num - 1])) || "join".equals(words[i.num - 1])) {
                                tables.add(words[i.num]);
                            }
                        }
                        ++i.num;
                    }
                }
                if (i.num >= words.length) break;
                if ("update".equals(words[i.num].trim().toLowerCase())) {
                    ++i.num;
                    if (i.num >= words.length) break;
                    tables.add(words[i.num]);
                }
                if (i.num >= words.length) break;
                if ("into".equals(words[i.num].trim().toLowerCase())) {
                    ++i.num;
                    if (i.num >= words.length) break;
                    tables.add(words[i.num]);
                }
            }
            ++i.num;
        }
    }

    public static String[] splitWord(String sql, LexicalAnalysisProcessor processor) {
        String[] spaceSplit;
        ArrayList<String> words = new ArrayList<String>();
        for (String word : spaceSplit = sql.split(" ")) {
            String[] wordSplits;
            word = word.replaceAll(",", "#,#");
            word = word.replaceAll("\\(", "#(#");
            word = word.replaceAll("\\)", "#)#");
            for (String wordSplit : wordSplits = word.split("#")) {
                if (StringHelper.isBlankOrNull(wordSplit)) continue;
                words.add(wordSplit);
                if (processor == null) continue;
                processor.process(wordSplit);
            }
        }
        String[] result = new String[words.size()];
        words.toArray(result);
        return result;
    }

    private static class Counter {
        int num = 0;

        private Counter() {
        }
    }
}

