/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jtester.annotations.Tracer;
import org.jtester.module.tracer.TracerSequece;
import org.jtester.module.tracer.spring.MethodTracerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTracerManager {
    private static ThreadLocal<List<MethodTracerEvent>> threadTracerEvents = new ThreadLocal();
    private static ThreadLocal<Stack<Class>> monitorBeans = new ThreadLocal();
    private static ThreadLocal<Tracer.Info> stringTypes = new ThreadLocal();
    private static ThreadLocal<Boolean> isBeanEnabled = new ThreadLocal();

    public static boolean isTracerEnabled() {
        Boolean bl = isBeanEnabled.get();
        return bl == null ? false : bl;
    }

    public static void initMonitorBeans(boolean isTracer, Class testClazz, Tracer tracer) {
        isBeanEnabled.set(isTracer);
        Stack<Class<Object>> beans = BeanTracerManager.monitorBeans();
        List<MethodTracerEvent> tracers = threadTracerEvents.get();
        if (beans == null) {
            beans = new Stack();
            monitorBeans.set(beans);
        }
        if (tracers == null) {
            tracers = new ArrayList<MethodTracerEvent>();
            threadTracerEvents.set(tracers);
        }
        beans.clear();
        beans.add(testClazz);
        tracers.clear();
        Tracer.Info type = tracer == null ? Tracer.Info.TOJSON : tracer.info();
        stringTypes.set(type);
    }

    public static void addTracer(MethodTracerEvent tracer) {
        tracer.clean();
        List<MethodTracerEvent> tracers = threadTracerEvents.get();
        tracers.add(tracer);
    }

    public static String endMonitorBean() {
        Stack<Class> stack = monitorBeans.get();
        if (stack != null) {
            stack.clear();
        }
        monitorBeans.remove();
        List<MethodTracerEvent> events = threadTracerEvents.get();
        if (events == null || events.size() == 0) {
            threadTracerEvents.remove();
            return null;
        }
        String sequence = TracerSequece.getSequenceDescription(events);
        if (events != null) {
            events.clear();
        }
        threadTracerEvents.remove();
        return sequence;
    }

    public static Stack<Class> monitorBeans() {
        return monitorBeans.get();
    }

    public static Class getLastBeanClazz() {
        Stack<Class> beans = BeanTracerManager.monitorBeans();
        if (beans == null || beans.size() == 1) {
            return null;
        }
        return beans.peek();
    }

    public static String toTracerString(Object o) {
        Tracer.Info type = stringTypes.get();
        String info = type.toInfoString(o);
        return info;
    }
}

