/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.spring;

import java.util.ArrayList;
import java.util.List;
import org.jtester.module.tracer.TracerBeanManager;
import org.jtester.module.tracer.spring.BeanTracerManager;
import org.jtester.utility.StringHelper;

public class MethodTracerEvent {
    private Class sourceClazz;
    private Class targetClazz;
    private String methodName;
    private List<String> paras;

    public MethodTracerEvent(Class sourceClazz, Class targetClazz, String methodName) {
        this.sourceClazz = sourceClazz;
        this.targetClazz = targetClazz;
        this.methodName = methodName;
        this.paras = new ArrayList<String>();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class getSourceClazz() {
        return this.sourceClazz;
    }

    public Class getTargetClazz() {
        return this.targetClazz;
    }

    public String getSourceBeanName() {
        String beanName = TracerBeanManager.getBeanName(this.sourceClazz);
        return StringHelper.isBlankOrNull(beanName) ? "test-class" : beanName;
    }

    public String getTargetBeanName() {
        return TracerBeanManager.getBeanName(this.targetClazz);
    }

    public void addPara(Object para) {
        String info = BeanTracerManager.toTracerString(para);
        this.paras.add(info);
    }

    public void clean() {
        this.paras.clear();
        this.paras = null;
    }

    public String toHtmlString() {
        StringBuffer html = new StringBuffer();
        html.append(MethodTracerEvent.htmlHeader(this.sourceClazz, this.targetClazz, this.methodName));
        html.append("<tr><td>paras</td>");
        html.append("<td>");
        boolean firstPara = true;
        for (String para : this.paras) {
            if (firstPara) {
                firstPara = false;
            } else {
                html.append("<br/>");
            }
            html.append(para);
        }
        html.append("&nbsp;</td></tr>");
        return html.toString();
    }

    public static String getResultHtml(Class source, Class target, String method, String result) {
        StringBuffer html = new StringBuffer();
        html.append(MethodTracerEvent.htmlHeader(source, target, method));
        html.append("<tr><td>result</td>");
        html.append("<td>");
        html.append(result);
        html.append("&nbsp;</td></tr>");
        return html.toString();
    }

    private static String htmlHeader(Class source, Class target, String method) {
        StringBuffer html = new StringBuffer();
        html.append("<tr><td colspan=2>");
        if (source == null) {
            html.append("<b>unkown source</b>");
        } else {
            html.append(String.format("<b title='%s'>%s</b>", source.getName(), TracerBeanManager.getSourceBeanName(source)));
        }
        html.append(" call ");
        if (target == null) {
            html.append("<b>unkown target</b>");
        } else {
            html.append(String.format("<b title='%s'>%s</b>", target.getName(), TracerBeanManager.getTargetBeanName(target)));
        }
        html.append(String.format("#%s", method));
        html.append("</td></tr>");
        return html.toString();
    }
}

