/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.spring;

import java.util.Stack;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jtester.module.tracer.TracerManager;
import org.jtester.module.tracer.spring.BeanTracerManager;
import org.jtester.module.tracer.spring.MethodTracerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanTracer
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Stack<Class> beans = BeanTracerManager.monitorBeans();
        if (beans == null) {
            return invocation.proceed();
        }
        Class<?> beanClazz = invocation.getThis().getClass();
        String method = invocation.getMethod().getName();
        Object[] paras = invocation.getArguments();
        MethodTracerEvent tracerEvent = this.addTraceEvent(beans, beanClazz, method, paras);
        TracerManager.addBeanTracerEvent(tracerEvent);
        try {
            Object result = invocation.proceed();
            TracerManager.addBeanTracerResult(tracerEvent, result);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            TracerManager.addBeanTracerException(tracerEvent, e);
            throw e;
        }
        finally {
            beans.pop();
        }
    }

    private MethodTracerEvent addTraceEvent(Stack<Class> beans, Class beanClaz, String methodName, Object[] args) {
        MethodTracerEvent tracerEvent = new MethodTracerEvent(beans.peek(), beanClaz, methodName);
        beans.push(beanClaz);
        for (Object para : args) {
            tracerEvent.addPara(para);
        }
        return tracerEvent;
    }
}

