/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.spring;

import java.lang.reflect.Modifier;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.JdkRegexpMethodPointcut;

public class TracerMethodRegexPointcut
extends JdkRegexpMethodPointcut {
    private static final long serialVersionUID = 8342662318985403824L;
    private static final String[] patterns = new String[]{".*"};
    private static final String[] FilterClazzPrefix = new String[]{"java.", "javax.", "org.springframework.", "org.hibernate.", "com.ibatis."};

    public TracerMethodRegexPointcut() {
        super.setPatterns(patterns);
    }

    public ClassFilter getClassFilter() {
        final ClassFilter filter = super.getClassFilter();
        return new ClassFilter(){

            public boolean matches(Class clazz) {
                int modifier = clazz.getModifiers();
                if (Modifier.isFinal(modifier)) {
                    return false;
                }
                String clazzName = clazz.getName();
                if (TracerMethodRegexPointcut.beenFilted(clazzName)) {
                    return false;
                }
                return filter.matches(clazz);
            }
        };
    }

    public static boolean beenFilted(String clazzName) {
        for (String prefix : FilterClazzPrefix) {
            if (!clazzName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

