/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.utils;

import ext.jtester.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.jtester.exception.JTesterException;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.ResourceHelper;

public class PropertiesReader {
    public Properties loadPropertiesFileFromUserHome(String propertiesFileName) {
        FileInputStream inputStream = null;
        try {
            if ("".equals(propertiesFileName)) {
                throw new IllegalArgumentException("Properties Filename must be given.");
            }
            Properties properties = new Properties();
            String userHomeDir = System.getProperty("user.home");
            File localPropertiesFile = new File(userHomeDir, propertiesFileName);
            if (!localPropertiesFile.exists()) {
                Properties properties2 = null;
                return properties2;
            }
            inputStream = new FileInputStream(localPropertiesFile);
            properties.load(inputStream);
            JTesterLogger.info("Loaded configuration file " + propertiesFileName + " from user home");
            Properties properties3 = properties;
            IOUtils.closeQuietly(inputStream);
            return properties3;
        }
        catch (FileNotFoundException e) {
            Properties properties = null;
            return properties;
        }
        catch (Throwable e) {
            throw new JTesterException("Unable to load configuration file: " + propertiesFileName + " from user home", e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    /*
     * Loose catch block
     */
    public Properties loadPropertiesFileFromClasspath(String propertiesFileName) {
        Properties properties;
        InputStream inputStream = null;
        try {
            if ("".equals(propertiesFileName)) {
                throw new IllegalArgumentException("Properties Filename must be given.");
            }
            Properties properties2 = new Properties();
            inputStream = ResourceHelper.getResourceAsStream(propertiesFileName);
            if (inputStream == null) {
                Properties properties3 = null;
                IOUtils.closeQuietly(inputStream);
                return properties3;
            }
            properties2.load(inputStream);
            properties = properties2;
            IOUtils.closeQuietly(inputStream);
        }
        catch (FileNotFoundException e) {
            Properties properties4 = null;
            return properties4;
        }
        catch (Throwable e2) {
            throw new JTesterException("Unable to load configuration file: " + propertiesFileName, e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return properties;
    }
}

