/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.bytecode.reflector.helper.MethodHelper;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public class JTesterLogger {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static int level = 0;
    private static File debugFile = new File(System.getProperty("user.dir") + "/target/jtester.log");

    private static void mark(String marker) {
        System.out.println(marker);
    }

    public static void debug(String info) {
        if (level <= 0) {
            JTesterLogger.mark("DEBUG: " + info);
        }
    }

    public static void warn(String warn) {
        if (level <= 2) {
            JTesterLogger.mark("WARNING: " + warn);
        }
    }

    public static void warn(String warn, Throwable e) {
        if (level <= 2) {
            JTesterLogger.mark("WARNING: " + warn);
            e.printStackTrace();
        }
    }

    public static void info(String info) {
        if (level <= 1) {
            JTesterLogger.mark("INFO: " + info);
        }
    }

    public static void error(String err, Throwable e) {
        JTesterLogger.mark("ERROR: " + err);
        e.printStackTrace();
    }

    public static void mark(String marker, Throwable e) {
        System.out.println(marker);
        e.printStackTrace();
    }

    public static void resetLog4jLevel() {
        String log4jxml = ConfigurationHelper.getString("log4j.xml.file");
        boolean log4jAvailable = ClazzHelper.isClassAvailable("org.apache.log4j.xml.DOMConfigurator");
        if (StringHelper.isBlankOrNull(log4jxml) || !log4jAvailable) {
            return;
        }
        try {
            URL url = ResourceHelper.getResourceUrl(log4jxml);
            Class domConfigurator = ClazzHelper.getClazz("org.apache.log4j.xml.DOMConfigurator");
            MethodHelper.invokeStatic(domConfigurator, "configure", url);
        }
        catch (Throwable e) {
            JTesterLogger.mark("reset log4j leve error, " + e == null ? "null" : e.getMessage());
        }
    }

    protected static void writerDebugInfo(String info) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(debugFile, true);
            writer.write(info);
            writer.write("\n");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

