/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterException;
import org.jtester.json.JSON;
import org.jtester.json.helper.JSONFeature;
import org.jtester.utility.ResourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonHelper {
    public static <T> void toDatFile(T o, String filename) {
        ResourceHelper.mkFileParentDir(filename);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(o);
            out.close();
        }
        catch (Throwable e) {
            throw new JTesterException(e);
        }
    }

    public static <T> void toJsonFile(T o, String filename) {
        String json = JSON.toJSON(o, new JSONFeature[0]);
        ResourceHelper.writeStringToFile(new File(filename), json);
    }

    public static <T> T fromDatFile(Class claz, String filename) {
        try {
            InputStream inputStream = ResourceHelper.getResourceAsStream(filename);
            ObjectInputStream in = new ObjectInputStream(inputStream);
            Object obj = in.readObject();
            in.close();
            return (T)obj;
        }
        catch (Throwable e) {
            throw new JTesterException(e);
        }
    }

    public static <T> T fromDatFile(Class returnClazz, Class pathClazz, String filename) {
        String path = ClazzHelper.getPathFromPath(pathClazz);
        return JsonHelper.fromDatFile(returnClazz, path + File.separatorChar + filename);
    }

    public static <T> T fromJsonFile(Class claz, String filename) {
        try {
            String json = ResourceHelper.readFromFile(filename);
            Object o = JSON.toObject(json, claz);
            return o;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJsonFile(Class returnClazz, Class pathClazz, String filename) {
        String path = ClazzHelper.getPathFromPath(pathClazz);
        return JsonHelper.fromJsonFile(returnClazz, path + File.separatorChar + filename);
    }

    public static String toJSON(Object o) {
        String json = JSON.toJSON(o, new JSONFeature[0]);
        return json;
    }
}

