/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jtester.utility.ArrayHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHelper {
    public static <T> List toList(T ... objects) {
        List<T> list = new ArrayList();
        if (objects == null || objects.length == 0) {
            return list;
        }
        if (objects.length == 1) {
            list = ListHelper.toList(objects[0], false);
            return list;
        }
        for (T o : objects) {
            list.add(o);
        }
        return list;
    }

    public static List toList(Object object, boolean withMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (object == null) {
            list.add(null);
            return list;
        }
        if (object instanceof Collection) {
            list.addAll((Collection)object);
            return list;
        }
        if (object.getClass().isArray()) {
            Object[] array;
            for (Object item : array = ArrayHelper.convertPrimitiveArrayToObjectArray(object)) {
                list.add(item);
            }
            return list;
        }
        if (withMap && object instanceof Map) {
            Collection values = ((Map)object).values();
            list.addAll(values);
            return list;
        }
        list.add(object);
        return list;
    }

    public static List toList(char[] values) {
        ArrayList<Character> objs = new ArrayList<Character>();
        char[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character value = Character.valueOf(arr$[i$]);
            objs.add(value);
        }
        return objs;
    }

    public static List toList(float[] values) {
        ArrayList<Float> objs = new ArrayList<Float>();
        float[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float value = Float.valueOf(arr$[i$]);
            objs.add(value);
        }
        return objs;
    }

    public static List toList(long[] values) {
        ArrayList<Long> objs = new ArrayList<Long>();
        long[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(short[] values) {
        ArrayList<Short> objs = new ArrayList<Short>();
        short[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Short value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(int[] values) {
        ArrayList<Integer> objs = new ArrayList<Integer>();
        int[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(double[] values) {
        ArrayList<Double> objs = new ArrayList<Double>();
        double[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(boolean[] values) {
        ArrayList<Boolean> objs = new ArrayList<Boolean>();
        boolean[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Boolean value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(byte[] values) {
        ArrayList<Byte> objs = new ArrayList<Byte>();
        byte[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte value = arr$[i$];
            objs.add(value);
        }
        return objs;
    }

    public static boolean isCollection(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Collection;
    }

    public static String toString(List list) {
        if (list == null) {
            return "null";
        }
        StringBuilder buff = new StringBuilder("[");
        boolean first = true;
        for (Object o : list) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(String.valueOf(o));
        }
        buff.append("]");
        return buff.toString();
    }
}

