/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrimitiveHelper {
    private static Map<Class, Object> map = new HashMap<Class, Object>();
    private static Map<Class, Class> couples;
    private static Set<Class<?>> primitiveClassSet;
    private static Set<Class<?>> primitiveRelativeTypes;

    public static Object getPrimitiveDefaultValue(Class claz) {
        if (map.containsKey(claz)) {
            return map.get(claz);
        }
        return null;
    }

    public static boolean isPrimitiveTypeEquals(Class expected, Class actual) {
        Class _expected = expected;
        if (couples.containsKey(expected)) {
            _expected = couples.get(expected);
        }
        Class _actual = actual;
        if (couples.containsKey(actual)) {
            _actual = couples.get(actual);
        }
        return _expected == _actual;
    }

    public static boolean doesEqual(Number num_1, Number num_2) {
        if (num_1 == null) {
            return num_2 == null;
        }
        if (num_2 == null) {
            return false;
        }
        if (PrimitiveHelper.canLongNumber(num_1) && PrimitiveHelper.canLongNumber(num_2)) {
            long l2;
            long l1 = num_1.longValue();
            return l1 == (l2 = num_2.longValue());
        }
        if (PrimitiveHelper.canDoubleNumber(num_1) && PrimitiveHelper.canDoubleNumber(num_2)) {
            double d2;
            double d1 = num_1.doubleValue();
            return d1 == (d2 = num_2.doubleValue());
        }
        return num_1.equals(num_2);
    }

    private static boolean canLongNumber(Number number) {
        return number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof BigInteger;
    }

    private static boolean canDoubleNumber(Number number) {
        return number instanceof Double || number instanceof Float || number instanceof BigDecimal;
    }

    public static boolean isPrimitiveType(Class type) {
        return primitiveClassSet.contains(type);
    }

    public static boolean isPrimitiveTypeOrRelative(Class type) {
        if (PrimitiveHelper.isPrimitiveType(type)) {
            return true;
        }
        return primitiveRelativeTypes.contains(type);
    }

    static {
        map.put(String.class, "");
        map.put(Integer.class, 0);
        map.put(Short.class, (short)0);
        map.put(Long.class, 0L);
        map.put(Byte.class, (byte)0);
        map.put(Float.class, Float.valueOf(0.0f));
        map.put(Double.class, 0.0);
        map.put(Character.class, Character.valueOf('\u0000'));
        map.put(Boolean.class, false);
        map.put(Integer.TYPE, 0);
        map.put(Short.TYPE, 0);
        map.put(Long.TYPE, 0);
        map.put(Byte.TYPE, 0);
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, 0.0);
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Boolean.TYPE, false);
        couples = new HashMap<Class, Class>();
        couples.put(Integer.class, Integer.TYPE);
        couples.put(Short.class, Short.TYPE);
        couples.put(Long.class, Long.TYPE);
        couples.put(Byte.class, Byte.TYPE);
        couples.put(Float.class, Float.TYPE);
        couples.put(Double.class, Double.TYPE);
        couples.put(Character.class, Character.TYPE);
        couples.put(Boolean.class, Boolean.TYPE);
        primitiveClassSet = new HashSet();
        primitiveClassSet.add(Boolean.TYPE);
        primitiveClassSet.add(Byte.TYPE);
        primitiveClassSet.add(Short.TYPE);
        primitiveClassSet.add(Integer.TYPE);
        primitiveClassSet.add(Long.TYPE);
        primitiveClassSet.add(Float.TYPE);
        primitiveClassSet.add(Double.TYPE);
        primitiveRelativeTypes = new HashSet();
        primitiveRelativeTypes.add(Boolean.class);
        primitiveRelativeTypes.add(Byte.class);
        primitiveRelativeTypes.add(Short.class);
        primitiveRelativeTypes.add(Integer.class);
        primitiveRelativeTypes.add(Long.class);
        primitiveRelativeTypes.add(Float.class);
        primitiveRelativeTypes.add(Double.class);
        primitiveRelativeTypes.add(String.class);
    }
}

