/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import ext.jtester.org.apache.commons.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.cpdetector.CodepageDetectorProxy;
import org.jtester.cpdetector.JChardetFacade;
import org.jtester.exception.JTesterException;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;

public class ResourceHelper {
    public static String readFromStream(InputStream is, String encoding) {
        String string;
        BufferedReader reader = null;
        String line = null;
        try {
            StringBuilder buffer = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            string = buffer.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(is);
        return string;
    }

    public static String readFromStream(InputStream is) {
        String encoding = ResourceHelper.getFileEncodingCharset(is);
        String context = ResourceHelper.readFromStream(is, encoding);
        return context;
    }

    public static String[] readLinesFromStream(InputStream is, String encoding) {
        String[] stringArray;
        BufferedReader reader = null;
        String line = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            stringArray = list.toArray(new String[0]);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(is);
        return stringArray;
    }

    public static String[] readLinesFromStream(InputStream is) {
        String encoding = ResourceHelper.getFileEncodingCharset(is);
        String[] lines = ResourceHelper.readLinesFromStream(is, encoding);
        return lines;
    }

    public static void writeStringToFile(File file, String content) {
        OutputStreamWriter writer = null;
        try {
            ResourceHelper.mkFileParentDir(file);
            writer = new FileWriter(file, false);
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyClassPathResource(String classPathResourceName, String fileSystemResourceName) {
        ResourceHelper.copyClassPathResource(classPathResourceName, new File(fileSystemResourceName));
    }

    public static void copyClassPathResource(String classPathResourceName, File fileSystemResourceFile) {
        InputStream resourceInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            resourceInputStream = ResourceHelper.class.getClassLoader().getResourceAsStream(classPathResourceName);
            ResourceHelper.mkFileParentDir(fileSystemResourceFile);
            fileOutputStream = new FileOutputStream(fileSystemResourceFile);
            IOUtils.copy(resourceInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            try {
                throw new JTesterException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceInputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resourceInputStream);
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void copyClassPathResourceToDir(String classPathResourceName, String fileSystemDirectoryName) {
        String fileName = StringHelper.substringAfterLast(classPathResourceName, "/");
        String fileSystemResourceName = fileSystemDirectoryName + "/" + fileName;
        ResourceHelper.copyClassPathResource(classPathResourceName, fileSystemResourceName);
    }

    public static URL getUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new JTesterException("Unable to create URL for file " + file.getName(), e);
        }
    }

    public static File findWikiFile(Class claz, String url) throws Exception {
        if (url.startsWith("file:")) {
            return new File(url.replace("file:", ""));
        }
        URL file = ClassLoader.getSystemResource(url);
        String newUrl = url;
        if (file == null && claz != null) {
            newUrl = ClazzHelper.getPathFromPath(claz) + File.separatorChar + url;
            file = ClassLoader.getSystemResource(newUrl);
        }
        if (file == null) {
            throw new RuntimeException(String.format("can't find resource in classpath:%s", newUrl));
        }
        return new File(file.toURI());
    }

    public static String defaultFileEncoding() {
        String encoding = System.getProperty("file.encoding", "utf-8");
        return encoding;
    }

    public static String getFileEncodingCharset(File file) {
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add(JChardetFacade.getInstance());
        try {
            Charset charset = Charset.forName(ResourceHelper.defaultFileEncoding());
            try {
                charset = detector.detectCodepage(file.toURL());
            }
            catch (IllegalArgumentException e) {
                charset = Charset.forName(ResourceHelper.defaultFileEncoding());
                JTesterLogger.warn("get file encoding error:" + e.getMessage() + ", use default encoding:" + ResourceHelper.defaultFileEncoding());
            }
            String fileCharacterEnding = charset.name();
            return fileCharacterEnding;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ResourceHelper.defaultFileEncoding();
        }
    }

    public static String getFileEncodingCharset(InputStream is) {
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add(JChardetFacade.getInstance());
        try {
            Charset charset = Charset.forName(ResourceHelper.defaultFileEncoding());
            try {
                charset = detector.detectCodepage(is, Integer.MAX_VALUE);
            }
            catch (IllegalArgumentException e) {
                charset = Charset.forName(ResourceHelper.defaultFileEncoding());
                JTesterLogger.warn("get file encoding error:" + e.getMessage() + ", use default encoding:" + ResourceHelper.defaultFileEncoding());
            }
            String fileCharacterEnding = charset.name();
            return fileCharacterEnding;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ResourceHelper.defaultFileEncoding();
        }
    }

    public static InputStream getResourceAsStream(String file) throws FileNotFoundException {
        String _file = file;
        if (file == null) {
            throw new RuntimeException("execute file name can't be null!");
        }
        InputStream ins = null;
        if (file.startsWith("file:")) {
            _file = file.replaceFirst("file:", "");
            ins = new FileInputStream(new File(_file));
            return ins;
        }
        if (file.startsWith("classpath:")) {
            _file = file.replaceFirst("classpath:", "");
        }
        if ((ins = ResourceHelper.class.getClassLoader().getResourceAsStream(_file)) == null) {
            throw new FileNotFoundException(String.format("can't find classpath resource[%s]!", file));
        }
        return ins;
    }

    public static URL getResourceUrl(String filename) {
        if (filename == null) {
            throw new RuntimeException("execute file name can't be null!");
        }
        if (filename.startsWith("file:")) {
            String _filename = filename.replaceFirst("file:", "");
            File file = new File(_filename);
            URL url = null;
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return url;
        }
        String resource = filename;
        if (filename.startsWith("classpath:")) {
            resource = filename.replaceFirst("classpath:", "");
        }
        URL url = ResourceHelper.class.getClassLoader().getResource(resource);
        return url;
    }

    public static InputStream getResourceAsStream(Class clazz, String fileName) throws FileNotFoundException {
        String packPath = ClazzHelper.getPathFromPath(clazz);
        String url = StringHelper.isBlankOrNull(packPath) ? fileName : packPath + "/" + fileName;
        InputStream is = ResourceHelper.class.getClassLoader().getResourceAsStream(url);
        if (is == null && !StringHelper.isBlankOrNull(packPath)) {
            is = clazz.getClassLoader().getResourceAsStream(fileName);
        }
        if (is == null) {
            if (StringHelper.isBlankOrNull(packPath)) {
                throw new FileNotFoundException(String.format("can't find class path resource in in classpath: [%s].", fileName));
            }
            throw new FileNotFoundException(String.format("can't find class path resource in in classpaths: [%s] and [%s]", url, fileName));
        }
        return is;
    }

    public static String readFromFile(String file) throws FileNotFoundException {
        InputStream stream = ResourceHelper.getResourceAsStream(file);
        return ResourceHelper.readFromStream(stream);
    }

    public static String readFromFile(File file) throws FileNotFoundException {
        if (file == null) {
            throw new RuntimeException("the file can't be null.");
        }
        if (!file.exists()) {
            throw new RuntimeException(String.format("the file[%s] isn't exists.", file.getName()));
        }
        String encoding = ResourceHelper.getFileEncodingCharset(file);
        String content = ResourceHelper.readFromStream(new FileInputStream(file), encoding);
        return content;
    }

    public static String readFromFile(Class clazz, String fileName) throws FileNotFoundException {
        if (StringHelper.isBlankOrNull(fileName)) {
            throw new RuntimeException("file name can't be null.");
        }
        if (fileName.startsWith("file:") || fileName.startsWith("classpath:")) {
            String content = ResourceHelper.readFromFile(fileName);
            return content;
        }
        InputStream is = ResourceHelper.getResourceAsStream(clazz, fileName);
        String content = ResourceHelper.readFromStream(is);
        return content;
    }

    public static String[] readLinesFromFile(String filePath) throws FileNotFoundException {
        InputStream stream = ResourceHelper.getResourceAsStream(filePath);
        String[] lines = ResourceHelper.readLinesFromStream(stream);
        return lines;
    }

    public static Properties loadPropertiesFrom(String file) {
        InputStream in = null;
        try {
            in = ResourceHelper.getResourceAsStream(file);
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("load properties from file[%s] error.", file), e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static boolean isResourceExists(Class claz, String file) {
        String pack = ClazzHelper.getPathFromPath(claz);
        String path = StringHelper.isBlankOrNull(pack) ? file : pack + "/" + file;
        try {
            URL url = ClassLoader.getSystemResource(path);
            return url != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String convertStreamToSQL(InputStream is) {
        String string;
        BufferedReader reader = null;
        String line = null;
        try {
            StringBuilder buffer = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("--")) continue;
                buffer.append(line + " ");
            }
            string = buffer.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(is);
        return string;
    }

    public static String getSuffixPath(File basePath, String filePath) {
        String prefixPath = basePath.getAbsolutePath().replaceAll("[\\/\\\\]+", "/");
        String fullPath = filePath.replaceAll("[\\/\\\\]+", "/");
        String suffixPath = filePath;
        if (fullPath.startsWith(prefixPath)) {
            suffixPath = fullPath.replace(prefixPath, "");
        }
        if (suffixPath.startsWith("/")) {
            suffixPath = suffixPath.substring(1);
        }
        return suffixPath;
    }

    public static boolean deleteFileOrDir(String path) {
        try {
            return ResourceHelper.deleteFileOrDir(new File(path));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean deleteFileOrDir(File path) {
        File[] files;
        if (!path.exists()) {
            return true;
        }
        if (path.isFile()) {
            path.delete();
            return true;
        }
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                ResourceHelper.deleteFileOrDir(file);
                continue;
            }
            file.delete();
        }
        return path.delete();
    }

    public static void mkFileParentDir(String file) {
        String _file = file.replaceAll("[\\/\\\\]+", "/");
        File path = new File(_file).getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    public static void mkFileParentDir(File file) {
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
    }
}

