/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.utility;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    public static final String EMPTY = "";
    public static final List<String> DEFAULT_EXCEPTION_FILTER = new ArrayList<String>(){
        private static final long serialVersionUID = -5015223773312948340L;
        {
            this.add("\\s*at\\s*org\\.jtester\\.fit\\.FitRunner\\.[^\\s]+");
            this.add("\\s*at\\s*org\\.testng\\.[^\\s]+");
            this.add("\\s*at\\s*sun\\.reflect\\.[^\\s]+");
            this.add("\\s*at\\s*java\\.lang\\.reflect\\.[^\\s]+");
            this.add("\\s*at\\s*fitlibrary\\.[^\\s]+");
        }
    };
    private static SimpleDateFormat simpleDateTimeFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat simpleTimeFormate = new SimpleDateFormat("mm:ss");
    private static final boolean[] Space_Chars = new boolean[256];

    public static boolean isBlankOrNull(String in) {
        if (in == null) {
            return true;
        }
        return in.trim().equals(EMPTY);
    }

    public static String trim(String source) {
        if (source == null) {
            return null;
        }
        return source.trim();
    }

    public static String camel(String name) {
        if (StringHelper.isBlankOrNull(name)) {
            return EMPTY;
        }
        StringBuffer b = new StringBuffer(name.length());
        StringTokenizer t = new StringTokenizer(name);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public static String camel(String name, String ... strings) {
        StringBuffer b = new StringBuffer(name);
        for (String s : strings) {
            b.append(" ");
            b.append(s);
        }
        return StringHelper.camel(b.toString());
    }

    public static String exceptionTrace(Throwable e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public static String exceptionTrace(Throwable e, List<String> filters) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        String tracer = w.toString();
        for (String regex : filters) {
            tracer = tracer.replaceAll(regex, EMPTY);
        }
        return tracer;
    }

    public static String simpleDateStr(Timestamp time) {
        return simpleTimeFormate.format(time);
    }

    public static String simpleDateTimeStr(long time) {
        if (time > 0L) {
            return simpleDateTimeFormate.format(new Timestamp(time));
        }
        return "--:--";
    }

    public static String simpleTimeStr(long time) {
        if (time > 0L) {
            return simpleTimeFormate.format(new Timestamp(time));
        }
        return "--";
    }

    public static int parseInt(String str, int _default) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            return _default;
        }
    }

    public static String[] splits(String string, String splitStr) {
        if (StringHelper.isBlankOrNull(string)) {
            return new String[0];
        }
        String temp = string.replaceAll("\\s", EMPTY);
        String[] splits = temp.split(splitStr);
        ArrayList<String> clazzes = new ArrayList<String>();
        for (String split : splits) {
            if (StringHelper.isBlankOrNull(split)) continue;
            clazzes.add(split);
        }
        return clazzes.toArray(new String[0]);
    }

    public static String join(String seperator, String[] strings) {
        if (strings == null || strings.length == 0) {
            return EMPTY;
        }
        boolean first = true;
        StringBuffer buff = new StringBuffer();
        for (String str : strings) {
            if (!first) {
                buff.append(seperator);
            } else {
                first = false;
            }
            buff.append(str);
        }
        return buff.toString();
    }

    public static String join(char seperator, char[] chars) {
        if (chars.length == 0 || chars == null) {
            return EMPTY;
        }
        boolean first = true;
        StringBuffer buff = new StringBuffer();
        for (char c : chars) {
            if (!first) {
                buff.append(seperator);
            } else {
                first = false;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static String formatHtml(String html) {
        String result = html;
        result = result.replaceAll("\"", "&quot;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll(" ", "&nbsp;");
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("\n", "<br/>");
        return result;
    }

    public static String toString(Object o) {
        StringBuilder buff = new StringBuilder("{");
        boolean first = true;
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            Collection oc = (Collection)o;
            for (Object o1 : oc) {
                if (!first) {
                    buff.append(",");
                } else {
                    first = false;
                }
                buff.append(StringHelper.toString(o1));
            }
            buff.append("}");
            return buff.toString();
        }
        if (o instanceof Object[]) {
            Object[] oa;
            for (Object o2 : oa = (Object[])o) {
                if (!first) {
                    buff.append(",");
                } else {
                    first = false;
                }
                buff.append(StringHelper.toString(o2));
            }
            buff.append("}");
            return buff.toString();
        }
        return o.toString();
    }

    public static String native2ascii(String nativeStr) {
        StringBuffer ret = new StringBuffer();
        if (nativeStr == null) {
            return null;
        }
        int maxLoop = nativeStr.length();
        for (int i = 0; i < maxLoop; ++i) {
            char character = nativeStr.charAt(i);
            int n127 = 127;
            int n4 = 4;
            if (character <= '\u007f') {
                ret.append(character);
                continue;
            }
            ret.append("\\u");
            String hexStr = Integer.toHexString(character);
            int zeroCount = 4 - hexStr.length();
            for (int j = 0; j < zeroCount; ++j) {
                ret.append('0');
            }
            ret.append(hexStr);
        }
        return ret.toString();
    }

    public static String ascii2native(String asciiStr) {
        if (asciiStr == null) {
            return null;
        }
        StringBuffer retBuf = new StringBuffer();
        int maxLoop = asciiStr.length();
        for (int i = 0; i < maxLoop; ++i) {
            if (asciiStr.charAt(i) == '\\') {
                int n5 = 5;
                int n6 = 6;
                int n16 = 16;
                if (i < maxLoop - 5 && (asciiStr.charAt(i + 1) == 'u' || asciiStr.charAt(i + 1) == 'U')) {
                    try {
                        retBuf.append((char)Integer.parseInt(asciiStr.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException e) {
                        retBuf.append(asciiStr.charAt(i));
                    }
                    continue;
                }
                retBuf.append(asciiStr.charAt(i));
                continue;
            }
            retBuf.append(asciiStr.charAt(i));
        }
        return retBuf.toString();
    }

    public static String native2asciiWithoutComment(String fileName) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        boolean continueFlg = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line.trim().startsWith("#") || line.trim().startsWith("!")) && !continueFlg) {
                buf.append(line);
            } else {
                continueFlg = line.endsWith("\\");
                buf.append(StringHelper.native2ascii(line));
            }
            buf.append("\n");
        }
        if (!fileName.endsWith("\n")) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String deleteWhitespace(String str) {
        if (StringHelper.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringHelper.isEmpty(str)) {
            return str;
        }
        if (StringHelper.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String ignoreWhiteSpace(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static final boolean isSpace(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return Space_Chars[ch];
    }

    static {
        StringHelper.Space_Chars[32] = true;
        StringHelper.Space_Chars[10] = true;
        StringHelper.Space_Chars[13] = true;
        StringHelper.Space_Chars[9] = true;
        StringHelper.Space_Chars[12] = true;
        StringHelper.Space_Chars[8] = true;
    }
}

