package com.alibaba.fastsql.funtions;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.util.FnvHash;

import java.util.ArrayList;
import java.util.List;

public class FunctionDef {
    private final String            name;
    private final SQLDataType       returnType;
    private final List<SQLDataType> parameterTypes = new ArrayList<SQLDataType>();
    private final boolean           varArgs;
    private       long              nameHash;

    public FunctionDef(String name, boolean varArgs, SQLDataType returnType, SQLDataType... parameterTypes) {
        this.name = name;
        this.varArgs = varArgs;
        this.returnType = returnType;
        for (int i = 0; i < parameterTypes.length; i++) {
            this.parameterTypes.add(parameterTypes[i]);
        }
    }

    public String getName() {
        return name;
    }

    public SQLDataType getReturnType() {
        return returnType;
    }

    public List<SQLDataType> getParameterTypes() {
        return parameterTypes;
    }

    public boolean isVarArgs() {
        return varArgs;
    }

    public long nameHash64() {
        if (nameHash == 0L) {
            nameHash = FnvHash.fnv1a_64_lower(name);
        }
        return nameHash;
    }

    public SQLDataType getLastParameterType() {
        if (parameterTypes.size() == 0) {
            return null;
        }
        return parameterTypes.get(parameterTypes.size() - 1);
    }

    public SQLDataType getParemeterType(int paramIndex) {
        if (paramIndex < parameterTypes.size()) {
            return parameterTypes.get(paramIndex);
        }

        if (isVarArgs()) {
            return parameterTypes.get(parameterTypes.size() - 1);
        }

        return null;
    }
}
