package com.alibaba.fastsql.funtions;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.util.FnvHash;

import java.util.LinkedHashMap;
import java.util.Map;

public class FunctionRepository {
    private final DbType dbType;
    private Map<Long, FunctionDef> functions = new LinkedHashMap<Long, FunctionDef>();

    public FunctionRepository(DbType dbType) {
        this.dbType = dbType;
    }

    public final static FunctionRepository MY_SQL = new FunctionRepository(DbType.mysql);

    static {
        MY_SQL.registerFunction("concat", true, SQLCharExpr.DEFAULT_DATA_TYPE, SQLCharExpr.DEFAULT_DATA_TYPE);
        MY_SQL.registerFunction("month", false, SQLIntegerExpr.DEFAULT_DATA_TYPE);
    }

    public void registerFunction(String name, SQLDataType returnType, SQLDataType... parameterTypes) {
        registerFunction(name, false, returnType, parameterTypes);
    }

    public void registerFunction(String name, boolean varArg, SQLDataType returnType, SQLDataType... parameterTypes) {
        FunctionDef func = new FunctionDef(name, varArg, returnType, parameterTypes);
        functions.put(func.nameHash64(), func);
    }

    public FunctionDef find(long hash) {
        return functions.get(hash);
    }


}
