package com.alibaba.fastsql.interpreter.filters;

public class IntFilter implements ConstFilter<Integer> {
    protected final int value;
    protected final BinaryOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public IntFilter(int value, BinaryOp operator, FieldValueProvider fieldValueProvider) {
        this.value = value;
        this.operator = operator;
        this.fieldValueProvider = fieldValueProvider;
    }

    public Integer getValue() {
        return value;
    }

    public Object getFieldValue(Object object) throws Exception {
        return fieldValueProvider.getFieldValue(object);
    }

    public boolean test(Object o) throws Exception {
        Object fieldValue = getFieldValue(o);

        if (fieldValue instanceof Integer
                || fieldValue instanceof Short
                || fieldValue instanceof Byte) {
            int intVal = ((Number) fieldValue).intValue();
            switch (operator) {
                case Eq:
                    return intVal == value;
                case Ne:
                    return intVal != value;
                case Ge:
                    return intVal >= value;
                case Gt:
                    return intVal > value;
                case Le:
                    return intVal <= value;
                case Lt:
                    return intVal < value;
                default:
                    throw new UnsupportedOperationException();
            }
        }

        if (fieldValue instanceof Long) {
            long longValue = ((Long) fieldValue).longValue();
            switch (operator) {
                case Eq:
                    return longValue == value;
                case Ne:
                    return longValue != value;
                case Ge:
                    return longValue >= value;
                case Gt:
                    return longValue > value;
                case Le:
                    return longValue <= value;
                case Lt:
                    return longValue < value;
                default:
                    throw new UnsupportedOperationException();
            }
        }

        throw new UnsupportedOperationException();
    }
}
