package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.Filter;

import java.util.Arrays;

public class ListIntFilter implements Filter  {
    private final int[] values;
    private ListOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public ListIntFilter(FieldValueProvider fieldValueProvider, ListOp operator, int[] values) {
        this.fieldValueProvider = fieldValueProvider;
        this.operator = operator;
        this.values = values;

        Arrays.sort(values);
    }

    public Object getFieldValue(Object object) throws Exception {
        return fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = getFieldValue(o);

        if (fieldValue instanceof Integer
                || fieldValue instanceof Short
                || fieldValue instanceof Byte) {
            int intVal = ((Number) fieldValue).intValue();

            switch (operator) {
                case IN:
                    return Arrays.binarySearch(values, intVal) >= 0;
                case NOT_IN:
                    return Arrays.binarySearch(values, intVal) < 0;
                default:
                    throw new UnsupportedOperationException();
            }
        }

        throw new UnsupportedOperationException();
    }

}
