package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.Filter;
import com.alibaba.fastsql.util.FnvHash;

import java.util.Arrays;

public class ListStringFilter implements Filter  {
    private final long[] hashCodes;
    private final String[] values;
    private final ListOp operator;
    private final FieldValueProvider fieldValueProvider;

    public ListStringFilter(FieldValueProvider fieldValueProvider, ListOp operator, String[] values) {
        this.fieldValueProvider = fieldValueProvider;
        this.operator = operator;
        this.hashCodes = new long[values.length];
        for (int i = 0; i < values.length; i++) {
            this.hashCodes[i] = FnvHash.fnv1a_64_lower(values[i]);
        }
        this.values = values;

        Arrays.sort(this.hashCodes);
        Arrays.sort(this.values);
    }

    public Object getFieldValue(Object object) throws Exception {
        return fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = getFieldValue(o);

        if (fieldValue instanceof String) {
            String strVal = (String) fieldValue;
            long hashCode = FnvHash.fnv1a_64_lower(strVal);

            switch (operator) {
                case IN:
                    return Arrays.binarySearch(hashCodes, hashCode) >= 0;
                case NOT_IN:
                    return Arrays.binarySearch(hashCodes, hashCode) < 0;
                default:
                    throw new UnsupportedOperationException();
            }
        }

        throw new UnsupportedOperationException();
    }
}
