package com.alibaba.fastsql.interpreter.filters;

public class StringFilter implements ConstFilter<String> {
    protected final String value;
    protected final BinaryOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public StringFilter(String value, BinaryOp operator, FieldValueProvider fieldValueProvider) {
        this.value = value;
        this.operator = operator;
        this.fieldValueProvider = fieldValueProvider;
    }

    public String getValue() {
        return value;
    }

    public Object getFieldValue(Object object) throws Exception {
        return fieldValueProvider.getFieldValue(object);
    }

    public boolean test(Object o) throws Exception {
        Object fieldValue = getFieldValue(o);

        if (fieldValue instanceof String) {
            String strVal = (String) fieldValue;
            if (strVal == null) {
                return false;
            }

            switch (operator) {
                case Eq:
                    return value.equalsIgnoreCase(strVal);
                case Ne:
                    return !value.equalsIgnoreCase(strVal);
                case Ge:
                    return value.compareToIgnoreCase(strVal) <= 0;
                case Gt:
                    return value.compareToIgnoreCase(strVal) < 0;
                case Le:
                    return value.compareToIgnoreCase(strVal) >= 0;
                case Lt:
                    return value.compareToIgnoreCase(strVal) > 0;
                default:
                    throw new UnsupportedOperationException();
            }
        }


        throw new UnsupportedOperationException();
    }
}
