/*
 * Copyright 1999-2017 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.fastsql.sql.dialect.hive.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class HiveSelectParser extends SQLSelectParser {

    public HiveSelectParser(SQLExprParser exprParser){
        super(exprParser);
    }

    public HiveSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache){
        super(exprParser, selectListCache);
    }

    public HiveSelectParser(String sql){
        this(new HiveExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new HiveExprParser(lexer);
    }

//    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
//        if (lexer.identifierEquals(FnvHash.Constants.SORTED) && selectQuery instanceof SQLSelectQueryBlock) {
//            lexer.nextToken();
//            accept(Token.BY);
//            for (;;) {
//                SQLExpr expr = this.expr();
//
//                SQLSelectOrderByItem sortByItem = new SQLSelectOrderByItem(expr);
//
//                if (lexer.token() == Token.ASC) {
//                    sortByItem.setType(SQLOrderingSpecification.ASC);
//                    lexer.nextToken();
//                } else if (lexer.token() == Token.DESC) {
//                    sortByItem.setType(SQLOrderingSpecification.DESC);
//                    lexer.nextToken();
//                }
//
//                ((SQLSelectQueryBlock) selectQuery).getSortBy().add(sortByItem);
//
//                if (lexer.token() == Token.COMMA) {
//                    lexer.nextToken();
//                } else {
//                    break;
//                }
//            }
//        }
//
//        return super.queryRest(selectQuery);
//    }

    protected void parseSortBy(SQLSelectQueryBlock queryBlock) {
        if (lexer.token() == Token.SORT) {
            lexer.nextToken();
            accept(Token.BY);
            for (;;) {
                SQLExpr expr = this.expr();

                SQLSelectOrderByItem sortByItem = new SQLSelectOrderByItem(expr);

                if (lexer.token() == Token.ASC) {
                    sortByItem.setType(SQLOrderingSpecification.ASC);
                    lexer.nextToken();
                } else if (lexer.token() == Token.DESC) {
                    sortByItem.setType(SQLOrderingSpecification.DESC);
                    lexer.nextToken();
                }

                queryBlock.addSortBy(sortByItem);

                if (lexer.token() == Token.COMMA) {
                    lexer.nextToken();
                } else {
                    break;
                }
            }
        }
    }
}
