package com.alibaba.fastsql.sql.dialect.hive.stmt;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatementImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class HiveCreateFunctionStatement extends SQLStatementImpl implements SQLCreateStatement {
    protected SQLName name;
    protected SQLExpr className;
    protected SQLExpr locationn;
    protected SQLExpr symbol;

    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof HiveASTVisitor) {
            accept0((HiveASTVisitor) visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(HiveASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, name);
            this.acceptChild(visitor, className);
            this.acceptChild(visitor, locationn);
            this.acceptChild(visitor, symbol);
        }
        visitor.endVisit(this);
    }

    public SQLName getName() {
        return name;
    }

    public void setName(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.name = x;
    }

    public SQLExpr getClassName() {
        return className;
    }

    public void setClassName(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.className = x;
    }

    public SQLExpr getLocationn() {
        return locationn;
    }

    public void setLocationn(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.locationn = x;
    }

    public SQLExpr getSymbol() {
        return symbol;
    }

    public void setSymbol(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.symbol = x;
    }
}
