/*
 * Copyright 1999-2017 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.fastsql.sql.dialect.presto.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixLexer;
import com.alibaba.fastsql.sql.parser.*;

/**
 * Created by wenshao on 16/9/13.
 */
public class PrestoExprParser extends SQLExprParser {

    {
        dbType = DbType.presto;
    }

    public PrestoExprParser(String sql, SQLParserFeature... features){
        this(new PrestoLexer(sql, features));
        this.lexer.nextToken();
    }

    public PrestoExprParser(Lexer lexer){
        super(lexer);
    }

    @Override
    protected SQLExpr parseInterval() {
        accept(Token.INTERVAL);
        SQLExpr value = expr();

        if (lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error. " + lexer.info());
        }

        String unit = lexer.stringVal();
        lexer.nextToken();

        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(SQLIntervalUnit.valueOf(unit.toUpperCase()));

        return intervalExpr;
    }
}

