package com.alibaba.fastsql.sql.optimizer;

import com.alibaba.fastjson.serializer.SerializerFeature;

public enum  OptimizerFeature {
    ConstFolding(0),
    PushUp(1),
    PushDown(2),
    MergeUnion(3),
    Ordinal(4),

    CastFloatToReal(5), // for aliyun ads

    PipesAsConcat(6),

    TypeInference(7),
    ;

    public final long mask;

    OptimizerFeature(int ordinal){
        mask = (1 << ordinal);
    }

    public static int of(OptimizerFeature[] features) {
        if (features == null) {
            return 0;
        }

        int value = 0;

        for (OptimizerFeature feature: features) {
            value |= feature.mask;
        }

        return value;
    }
}
