package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.*;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;

import java.util.List;

public class CastFloatToReal extends SQLASTVisitorAdapter {
    public boolean visit(SQLBinaryOpExpr x) {
        if (x.isLeftNameAndRightLiteral()) {
            SQLName left = (SQLName) x.getLeft();
            SQLLiteralExpr right = (SQLLiteralExpr) x.getRight();
            SQLDataType dataType = left.computeDataType();
            if (dataType.nameHashCode64() == FnvHash.Constants.FLOAT
                    || dataType.nameHashCode64() == FnvHash.Constants.REAL) {
                if (right instanceof SQLNumberExpr) {
                    x.setRight(new SQLRealExpr(((SQLNumberExpr) right).getNumber().floatValue()));
                }
            }
        }

        return true;
    }

    public boolean visit(SQLInListExpr x) {
        SQLDataType dataType = x.getExpr().computeDataType();

        if (dataType.nameHashCode64() == FnvHash.Constants.FLOAT
                || dataType.nameHashCode64() == FnvHash.Constants.REAL) {
            List<SQLExpr> targetList = x.getTargetList();
            for (int i = 0; i < targetList.size(); i++) {
                SQLExpr val = targetList.get(i);
                if (val instanceof SQLNumberExpr) {
                    SQLExpr real = new SQLRealExpr(((SQLNumberExpr) val).getNumber().floatValue());
                    real.setParent(x);
                    targetList.set(i, real);
                }
            }
        }

        return true;
    }

    public boolean visit(SQLBetweenExpr x) {
        SQLDataType dataType = x.getTestExpr().computeDataType();

        if (dataType.nameHashCode64() == FnvHash.Constants.FLOAT
                || dataType.nameHashCode64() == FnvHash.Constants.REAL) {
            SQLExpr begin = x.getBeginExpr();
            if (begin instanceof SQLNumberExpr) {
                x.setBeginExpr(new SQLRealExpr(((SQLNumberExpr) begin).getNumber().floatValue()));
            }

            SQLExpr end = x.getEndExpr();
            if (end instanceof SQLNumberExpr) {
                x.setEndExpr(new SQLRealExpr(((SQLNumberExpr) end).getNumber().floatValue()));
            }
        }

        return true;
    }
}
