package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.*;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

public class Constant extends SQLASTVisitorAdapter {
    private SchemaRepository repository;

    public Constant() {

    }

    public Constant(SchemaRepository repository) {
        this.repository = repository;
    }

    public void endVisit(SQLSelectQueryBlock x) {
        SQLExpr where = x.getWhere();
        if (where instanceof SQLBooleanExpr && ((SQLBooleanExpr) where).getBooleanValue()) {
            x.setWhere(null);
        }
    }

    public boolean visit(SQLBinaryOpExprGroup x) {
        for (int i = x.getItems().size() - 1; i >= 0; i--) {
            x.getItems().get(i).accept(this);
        }

        if (x.getOperator() == SQLBinaryOperator.BooleanOr) {
            for (int i = x.getItems().size() - 1; i >= 0; i--) {
                SQLExpr expr = x.getItems().get(i);
                if (expr instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) expr).getBooleanValue()) {
                        if (SQLUtils.replaceInParent(x, expr)) {
                            return false;
                        }
                    } else {
                        x.getItems().remove(i);
                    }
                }
            }
        } else if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            for (int i = x.getItems().size() - 1; i >= 0; i--) {
                SQLExpr expr = x.getItems().get(i);
                if (expr instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) expr).getBooleanValue()) {
                        x.getItems().remove(i);
                    } else {
                        if (SQLUtils.replaceInParent(x, expr)) {
                            return false;
                        }
                    }
                }
            }
        }

        return false;
    }

    public boolean visit(SQLBinaryOpExpr x) {
        x.getLeft().accept(this);
        x.getRight().accept(this);

        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();

        switch (x.getOperator()) {
            case Equality:
                if (left instanceof SQLLiteralExpr
                        && right instanceof SQLLiteralExpr
                        && left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                } else if (left instanceof SQLLiteralExpr
                        && right instanceof SQLLiteralExpr
                        && left.getClass() == right.getClass()
                        && !left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                } else if (left instanceof SQLIdentifierExpr
                        && right instanceof SQLIdentifierExpr
                        && left.equals(right)) {
                    SQLColumnDefinition column = ((SQLIdentifierExpr) left).getResolvedColumn();
                    if (column != null && column.containsNotNullConstaint()) {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    } else {
                        SQLUtils.replaceInParent(x, new SQLBinaryOpExpr(left.clone(), SQLBinaryOperator.IsNot, new SQLNullExpr()));
                    }
                } else if (left instanceof SQLPropertyExpr
                        && right instanceof SQLPropertyExpr
                        && left.equals(right)) {
                    SQLColumnDefinition column = ((SQLPropertyExpr) left).getResolvedColumn();
                    if (column != null && column.containsNotNullConstaint()) {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    } else {
                        SQLUtils.replaceInParent(x, new SQLBinaryOpExpr(left.clone(), SQLBinaryOperator.IsNot, new SQLNullExpr()));
                    }
                }
                break;
            case LessThan:
            case GreaterThan:
                if (left instanceof SQLName
                        && right instanceof SQLName && left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                }
                break;
            case NotEqual:
            case LessThanOrGreater:
                if (left instanceof SQLLiteralExpr
                        && right instanceof SQLLiteralExpr
                        && left.getClass() == right.getClass()) {
                    if (left.equals(right)) {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                    } else {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    }
                }
                break;
            case BooleanOr:
                if (left instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) left).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, left);
                    } else {
                        SQLUtils.replaceInParent(x, right);
                    }
                } else if (right instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) right).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, right);
                    } else {
                        SQLUtils.replaceInParent(x, left);
                    }
                }
                break;
            case BooleanAnd:
                if (left instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) left).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, right);
                    } else {
                        SQLUtils.replaceInParent(x, left);
                    }
                } else if (right instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr) right).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, left);
                    } else {
                        SQLUtils.replaceInParent(x, right);
                    }
                }
                break;
            case Like:
                SQLColumnDefinition column = null;
                if (left instanceof SQLIdentifierExpr) {
                    column = ((SQLIdentifierExpr) left).getResolvedColumn();
                } else if (left instanceof SQLPropertyExpr) {
                    column = ((SQLPropertyExpr) left).getResolvedColumn();
                }

                if (column != null
                        && column.containsNotNullConstaint()
                        && right instanceof SQLCharExpr)
                {
                    boolean matchAll = false;
                    String pattern = ((SQLCharExpr) right).getText();
                    if (pattern.length() > 0) {
                        int count = 0;
                        for (int i = 0; i < pattern.length(); ++i) {
                            char ch = pattern.charAt(i);
                            if (ch == '%') {
                                count++;
                            }
                        }
                        if (count == pattern.length()) {
                            matchAll = true;
                        }
                    }

                    if (matchAll) {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    }
                }
                break;
            default:
                break;
        }

        return false;
    }
}
