package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

public class MergeUnion extends SQLASTVisitorAdapter {
    public boolean visit(SQLUnionQuery x) {
        switch (x.getOperator()) {
            case UNION:
                break;
            default:
                return true;
        }

        x.getLeft().accept(this);
        x.getRight().accept(this);

        if (x.getLeft() instanceof SQLSelectQueryBlock && x.getRight() instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock left = (SQLSelectQueryBlock) x.getLeft();
            SQLSelectQueryBlock right = (SQLSelectQueryBlock) x.getRight();

            if (!left.equalsForMergeJoin(right)) {
                return false;
            }

            SQLSelectQueryBlock queryBlock = left.clone();
            if (right.getWhere() != null) {
                SQLExpr rightWhere = right.getWhere().clone();
                if (rightWhere instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr) rightWhere).getOperator() == SQLBinaryOperator.BooleanAnd) {
                    ((SQLBinaryOpExpr) rightWhere).setBracket(true);
                }

                queryBlock.whereOr(rightWhere);

                if (queryBlock.getWhere() instanceof SQLBinaryOpExprGroup) {
                    ((SQLBinaryOpExprGroup) queryBlock.getWhere()).optimize();
                }
            }

            SQLObject parent = x.getParent();
            if (parent instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery) parent;
                if (union.getLeft() == x) {
                    union.setLeft(queryBlock);
                } else {
                    union.setRight(queryBlock);
                }
                return false;
            } else if (parent instanceof SQLUnionQueryTableSource) {
                if (parent.getParent() instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock parentParent = (SQLSelectQueryBlock) parent.getParent();
                    if (parentParent.getFrom() == parent) {
                        parentParent.setFrom(new SQLSubqueryTableSource(queryBlock));
                        return false;
                    }
                }
            }
        }

        return false;
    }
}
