package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.statement.*;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

import java.util.List;

public class Ordinal extends SQLASTVisitorAdapter {
    private int replaceCount = 0;

    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectItem> selectItems = x.getSelectList();

        SQLSelectGroupByClause groupBy = x.getGroupBy();

        if (groupBy != null && !groupBy.isWithCube() && !groupBy.isWithRollUp()) {
            for (int i = 0; i < groupBy.getItems().size(); i++) {
                SQLExpr expr = groupBy.getItems().get(i);

                if (expr instanceof SQLLiteralExpr) {
                    continue;
                }

                for (int j = 0; j < selectItems.size(); j++) {
                    SQLExpr selectItemExpr = selectItems.get(j).getExpr();
                    if (expr.equals(selectItemExpr)) {
                        SQLExpr indexExpr = new SQLIntegerExpr(j + 1);
                        indexExpr.setParent(x);
                        groupBy.getItems().set(i, indexExpr);
                        replaceCount++;
                        break;
                    }
                }
            }
        }

        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null && (groupBy == null || (!groupBy.isWithCube() && !groupBy.isWithRollUp()))) {
            for (int i = 0; i < orderBy.getItems().size(); i++) {
                SQLSelectOrderByItem orderByItem = orderBy.getItems().get(i);
                SQLExpr expr = orderByItem.getExpr();
                if (expr instanceof SQLLiteralExpr) {
                    continue;
                }

                for (int j = 0; j < selectItems.size(); j++) {
                    SQLExpr selectItemExpr = selectItems.get(j).getExpr();
                    if (expr.equals(selectItemExpr)) {
                        orderByItem.setExpr(new SQLIntegerExpr(j + 1));
                        replaceCount++;
                        break;
                    }
                }
            }
        }

        return false;
    }

    public boolean visit(SQLInsertStatement x) {
        return false;
    }

    public boolean visit(SQLUpdateStatement x) {
        return false;
    }

    public boolean visit(SQLDeleteStatement x) {
        return false;
    }

    public int getReplaceCount() {
        return replaceCount;
    }
}
