package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

import java.util.List;

public class PipesAsConcat extends SQLASTVisitorAdapter {
    private int replaceCount = 0;

    public boolean visit(SQLBinaryOpExpr x) {
        SQLBinaryOperator operator = x.getOperator();

        if (operator == SQLBinaryOperator.Concat) {
            SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");

            List<SQLExpr> items = SQLBinaryOpExpr.split(x);
            for (SQLExpr item : items) {
                concat.addParameter(item);
            }

            if (SQLUtils.replaceInParent(x, concat)) {
                replaceCount++;
                concat.accept(this);
                return false;
            }
        }

        return true;
    }

    public int getReplaceCount() {
        return replaceCount;
    }
}
