package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.*;
import com.alibaba.fastsql.sql.ast.expr.*;
import com.alibaba.fastsql.sql.ast.statement.*;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushDown extends SQLASTVisitorAdapter {
    private int optimizedCount = 0;

    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectItem> selectList = x.getSelectList();
        for (SQLSelectItem selectItem : selectList) {
            selectItem.accept(this);
        }

        {
            SQLExpr where = x.getWhere();
            if (where != null) {
                where.accept(this);
            }
        }

        {
            SQLTableSource from = x.getFrom();
            if (from != null) {
                from.accept(this);
            }
        }

        SQLTableSource from = x.getFrom();
        if (!(from instanceof SQLSubqueryTableSource
                && ((SQLSubqueryTableSource) from).getSelect().getQuery() instanceof SQLSelectQueryBlock)) {
            return false;
        }

        SQLSelectQueryBlock subQuery = ((SQLSubqueryTableSource) from).getSelect().getQueryBlock();
        for (SQLSelectItem selectItem : subQuery.getSelectList()) {
            // window function
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLAggregateExpr
                    && ((SQLAggregateExpr) expr).getOver() != null) {
                return false;
            }
        }

        boolean allColumnMatched = false;
        SQLSelectItem aggItem = null;
        if (selectList.size() == 1) {
            SQLExpr expr = selectList.get(0).getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                allColumnMatched = true;
            } else if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr) expr).getName().equals("*")) {
                allColumnMatched = true;
            } else if (expr instanceof SQLAggregateExpr) {
                SQLAggregateExpr aggExpr = ((SQLAggregateExpr) expr).clone();
                if (aggExpr.getArguments().size() == 1
                        && aggExpr.methodNameHashCode64() == FnvHash.Constants.COUNT) {
                    SQLExpr arg = aggExpr.getArguments().get(0);
                    ExprReplaceVisitor replaceVisitor = new ExprReplaceVisitor(x, subQuery);
                    arg.accept(replaceVisitor);

                    if (replaceVisitor.repalcedFailCount > 0) {
                        return false;
                    }

                    aggItem = new SQLSelectItem(aggExpr, selectList.get(0).getAlias());
                }
            }
        }

        if ((!(allColumnMatched || aggItem != null))) {
            List<SQLSelectItem> subSelectList = subQuery.getSelectList();
            if (subSelectList.size() >= selectList.size()) {
                boolean match = true;
                for (int i = 0; i < selectList.size(); i++) {
                    SQLExpr selectItemExpr = selectList.get(i).getExpr();
                    SQLSelectItem subSelectItem = subSelectList.get(i);

                    if (selectItemExpr instanceof SQLIdentifierExpr || selectItemExpr instanceof SQLPropertyExpr) {
                        long nameHashCode64 = ((SQLName) selectItemExpr).nameHashCode64();
                        long subSelectItemHashCoe = FnvHash.hashCode64(subSelectItem.computeAlias());
                        if (nameHashCode64 != subSelectItemHashCoe) {
                            match = false;
                            break;
                        }
                    } else {
                        match = false;
                        break;
                    }

                }
                if (match) {
                    allColumnMatched = true;
                }
            }
        }

        SQLExpr where = null;
        if (x.getWhere() != null) {
            where = x.getWhere().clone();
            ExprReplaceVisitor whereVisitor = new ExprReplaceVisitor(x, subQuery);
            where.accept(whereVisitor);

            if (whereVisitor.repalcedFailCount > 0) {
                return false;
            }
        }

        if (allColumnMatched || aggItem != null) {
            SQLSelectQueryBlock queryBlock = subQuery.clone();
            if (aggItem != null) {
                SQLAggregateExpr aggregateExpr = (SQLAggregateExpr) aggItem.getExpr();

                List<SQLSelectItem> subSelectList = queryBlock.getSelectList();
                if (aggregateExpr.getArguments().size() == 1 && aggregateExpr.getArguments().get(0) instanceof SQLAllColumnExpr) {
                    aggregateExpr.getArguments().clear();
                    for (int i = 0; i < subSelectList.size(); i++) {
                        aggregateExpr.addArgument(subSelectList.get(i).getExpr());
                    }
                }

                subSelectList.clear();
                queryBlock.addSelectItem(aggItem);

                if (queryBlock.getDistionOption() == SQLSetQuantifier.DISTINCT) {
                    queryBlock.setDistionOption(0);
                    aggregateExpr.setOption(SQLAggregateOption.DISTINCT);
                }
            }

            queryBlock.addOrderBy(x.getOrderBy());

            final AtomicBoolean aggregate = new AtomicBoolean();
            if (queryBlock.getGroupBy() != null) {
                aggregate.set(true);
            }

            if (aggregate.get() && where != null) {
                SQLASTVisitorAdapter v = new SQLASTVisitorAdapter() {
                    public boolean visit(SQLAggregateExpr x) {
                        aggregate.set(true);
                        return false;
                    }
                };
                where.accept(v);
            }

            if (aggregate.get()) {
                queryBlock.addHaving(where);
            } else {
                queryBlock.addWhere(where);
            }

            SQLLimit limit = x.getLimit();
            if (limit != null) {
                if (queryBlock.getLimit() == null) {
                    queryBlock.setLimit(limit);
                } else {
                    return false; // TODO limit merge
                }
            }

            SQLObject parent = x.getParent();

            if (parent instanceof SQLSelect) {
                SQLSelect select = (SQLSelect) x.getParent();
                select.setQuery(queryBlock);
                queryBlock.accept(this);

            } else if (parent instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery) x.getParent();

                if (union.getLeft() == x) {
                    union.setLeft(queryBlock);
                } else {
                    union.setRight(queryBlock);
                }

                queryBlock.accept(this);
            }
        }

        return false;
    }

    class ExprReplaceVisitor extends SQLASTVisitorAdapter {
        private final SQLSelectQueryBlock queryBlock;
        private final SQLSelectQueryBlock subQueryBlock;

        private int repalcedFailCount = 0;

        public ExprReplaceVisitor(SQLSelectQueryBlock queryBlock, SQLSelectQueryBlock subQueryBlock) {
            this.queryBlock = queryBlock;
            this.subQueryBlock = subQueryBlock;
        }

        public boolean visit(SQLIdentifierExpr x) {
            SQLSelectItem selectItem = subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                repalcedFailCount++;
                return false;
            }

            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                repalcedFailCount++;
            }

            return false;
        }

        public boolean visit(SQLPropertyExpr x) {
            if (!(x.getOwner() instanceof SQLIdentifierExpr)) {
                repalcedFailCount++;
                return false;
            }

            SQLIdentifierExpr owner = (SQLIdentifierExpr) x.getOwner();
            if (queryBlock.getFrom().aliasHashCode64() != owner.nameHashCode64()) {
                repalcedFailCount++;
                return false;
            }

            if (x.getName().equals("*")) {
                if (!SQLUtils.replaceInParent(x, new SQLAllColumnExpr())) {
                    repalcedFailCount++;
                }
                return false;
            }

            SQLSelectItem selectItem = subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                repalcedFailCount++;
                return false;
            }

            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                repalcedFailCount++;
            }

            return false;
        }
    }
}
