package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.statement.*;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

/**
 * select (select 1) a, fid from t -> select 1 a, fid from t
 */
public class PushDownQueryExpr extends SQLASTVisitorAdapter {
    public boolean visit(SQLQueryExpr x) {
        SQLSelect select = x.getSubQuery();
        select.accept(this);

        SQLSelectQueryBlock query = select.getQueryBlock();

        // select (select 1) a, fid from t -> select 1 a, fid from t
        if (query != null) {
            if (query.getFrom() == null && query.getSelectList().size() == 1) {
                SQLExpr expr = query.getSelectList().get(0).getExpr().clone();
                SQLUtils.replaceInParent(x, expr);
            }
        }

        return false;
    }
}
