package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.funtions.FunctionDef;
import com.alibaba.fastsql.funtions.FunctionRepository;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.*;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;

import java.util.List;

public class TypeInference extends SQLASTVisitorAdapter {
    private int replaceCount = 0;
    private FunctionRepository functionRepository = FunctionRepository.MY_SQL;

    public boolean visit(SQLMethodInvokeExpr x) {
        final long hash = x.methodNameHashCode64();

        FunctionDef functionDef = findFunction(hash);

        final List<SQLExpr> arguments = x.getArguments();
        if (functionDef != null) {
            for (int i = 0; i < arguments.size(); i++) {
                SQLDataType type = functionDef.getParemeterType(i);
                SQLExpr arg = arguments.get(i);

                if (type == null) {
                    continue;
                }

                if (FnvHash.Constants.CHAR == type.nameHashCode64()) {

                    if (arg instanceof SQLIntegerExpr) {
                        String chars = ((SQLIntegerExpr) arg).getNumber().toString();
                        SQLCharExpr charExpr = new SQLCharExpr(chars);
                        charExpr.setParent(x);
                        arguments.set(i, charExpr);
                        replaceCount++;

                    } else if (arg instanceof SQLMethodInvokeExpr) {
                        SQLMethodInvokeExpr argFunction = (SQLMethodInvokeExpr) arg;
                        FunctionDef paramFunctionDef = findFunction(argFunction.methodNameHashCode64());
                        if (paramFunctionDef != null) {
                            SQLDataType paramType = paramFunctionDef.getReturnType();
                            if (FnvHash.Constants.BIGINT == paramType.nameHashCode64()) {
                                SQLCastExpr castExpr = new SQLCastExpr(arg, new SQLCharacterDataType("CHAR"));
                                castExpr.setParent(x);
                                arguments.set(i, castExpr);
                                replaceCount++;
                            }
                        }
                    }
                }
            }
        }

        return true;
    }

    public FunctionDef findFunction(long nameHash) {
        return functionRepository.find(nameHash);
    }

}
