/*
 * Copyright 1999-2017 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.DbType;

public interface JdbcConstants {
    DbType JTDS              = DbType.sqlserver;
    DbType HSQL              = DbType.hsql;
    DbType DB2               = DbType.db2;
    DbType POSTGRESQL        = DbType.postgresql;
    DbType SQL_SERVER        = DbType.sqlserver;
    DbType ORACLE            = DbType.oracle;
    DbType ALI_ORACLE        = DbType.oracle;
    DbType MYSQL             = DbType.mysql;
    DbType MARIADB           = DbType.mariadb;
    DbType DERBY             = DbType.derby;
    DbType HBASE             = DbType.hbase;
    DbType HIVE              = DbType.hive;
    DbType H2                = DbType.h2;
    DbType DM                = DbType.dm; // dm.jdbc.driver.DmDriver
    DbType KINGBASE          = DbType.kingbase;
    DbType GBASE             = DbType.gbase;
    DbType OCEANBASE         = DbType.oceanbase;
    DbType INFORMIX          = DbType.informix;
    /**
     * aliyun odps
     */
    DbType ODPS              = DbType.odps;
    DbType TERADATA          = DbType.teradata;
    DbType PHOENIX           = DbType.phoenix;
    DbType ENTERPRISEDB        = DbType.edb;
    DbType KYLIN               = DbType.kylin; // org.apache.kylin.jdbc.Driver
    DbType SQLITE              = DbType.sqlite;
    DbType ALIYUN_ADS          = DbType.ads;
    DbType PRESTO              = DbType.presto;
    DbType ELASTIC_SEARCH      = DbType.elastic_search;
    DbType ALIYUN_DRDS          = DbType.drds;
}
