/*
 * Copyright 1999-2017 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.fastsql.wall.spi;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.fastsql.sql.dialect.oracle.visitor.OracleExportParameterVisitor;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.visitor.ExportParameterVisitor;
import com.alibaba.fastsql.wall.WallConfig;
import com.alibaba.fastsql.wall.WallProvider;
import com.alibaba.fastsql.wall.WallVisitor;

public class OracleWallProvider extends WallProvider {

    public final static String DEFAULT_CONFIG_DIR = "META-INF/fastsql/wall/oracle";

    public OracleWallProvider(){
        this(new WallConfig(DEFAULT_CONFIG_DIR));
    }

    public OracleWallProvider(WallConfig config){
        super(config, DbType.oracle);
    }

    @Override
    public SQLStatementParser createParser(String sql) {
        return new OracleStatementParser(sql, SQLParserFeature.EnableSQLBinaryOpExprGroup);
    }

    @Override
    public WallVisitor createWallVisitor() {
        return new OracleWallVisitor(this);
    }

    @Override
    public ExportParameterVisitor createExportParameterVisitor() {
        return new OracleExportParameterVisitor();
    }
}
