# Support / Issues

Please [open an issue](https://github.com/sdelements/lets-chat/issues/new) for support and questions.


# Contributing to Let's Chat

Looking to contribute something to Let's Chat? **Here's how you can help.**

Please take a moment to review this document in order to make the contribution
process easy and effective for everyone involved.

Following these guidelines helps to communicate that you respect the time of
the developers managing and developing this open source project. In return,
they should reciprocate that respect in addressing your issue or assessing
patches and features.


## Using the issue tracker

Having trouble installing Let's Chat? Search for similar issues or post your new problem on the [mailing list][mailing-list].

The [issue tracker][tracker] is the preferred channel for [bug reports](#bug-reports),
[features requests](#feature-requests) and [submitting pull requests](#pull-requests),
but please respect the following restrictions:


* Please provide as much details about the problem you are encountering (platform, version on node/npm/mongo, etc)

* Please **do not** derail or troll issues. Keep the discussion on topic and
  respect the opinions of others.


## Issues and labels

Our bug tracker utilizes several labels to help organize and identify issues.
They do not signal any commitment from us to deliver. Here's what they
represent and how we use them:

#### Labels

- `bug` - Bugs that are reported to us or found by us.
- `feature` - Issues asking for a new feature to be added, or an existing one 
  to be extended or modified.


- `duplicate` - Issues that duplicate an already existing issue.
- `invalid` - Issues that are no longer valid.
- `wontfix` - Issues that are no longer valid.


- `xmpp` - Issues that are related to XMPP functionality.

For a complete look at our labels, see the [project labels page][labels].

#### Milestones

- `backlog` - Issues that are we are not committing to yet, but may be nice to
  have in the future.


## Bug reports

A bug is a _demonstrable problem_ that is caused by the code in the repository.
Good bug reports are extremely helpful, so thanks!

Guidelines for bug reports:

0. **Search both GitHub issue and the mailing list**.

2. **Check if the issue has been fixed** &mdash; try to reproduce it using the
   latest `master` or development branch in the repository.


A good bug report shouldn't leave others needing to chase you up for more
information. Please try to be as detailed as possible in your report. What is
your environment? What steps will reproduce the issue? What browser(s) and OS
experience the problem? What
would you expect to be the outcome? All these details will help people to fix
any potential bugs.


## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea
fits with the scope and aims of the project. It's up to *you* to make a strong
case to convince the project's developers of the merits of this feature. Please
provide as much detail and context as possible.


## Pull requests

Good pull requests—patches, improvements, new features—are a fantastic
help. They should remain focused in scope and avoid containing unrelated
commits.

**Please ask first** before embarking on any significant pull request (e.g.
implementing features, refactoring code, porting to a different language),
otherwise you risk spending a lot of time working on something that the
project's developers might not want to merge into the project.


## License

By contributing your code, you agree to license your contribution under the
[MIT License](LICENSE).


[labels]: https://github.com/sdelements/lets-chat/labels
[tracker]: https://github.com/sdelements/lets-chat/issues
