/*
 * Decompiled with CFR 0.152.
 */
package com.netease.wd.crossorigin.filter;

import com.netease.wd.crossorigin.utils.ConfigUtil;
import com.netease.wd.crossorigin.utils.CrossOriginUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CrossOriginFilter
implements Filter {
    private static Logger logger = Logger.getLogger(CrossOriginFilter.class);
    private List<String> allowOrigins = null;
    private List<String> allowMethods = null;
    private List<String> allowHeaders = null;
    private String allowOriginStr = null;
    private String allowMethodStr = null;
    private String allowHeaderStr = null;
    private String exposeHeaderStr = null;
    private boolean supportCredentials = false;
    private int maxAge = -1;
    private boolean checkReferer = false;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.doOptions(request, response, chain);
        } else {
            this.doRequest(request, response, chain);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.allowOrigins = ConfigUtil.parseParam(config.getInitParameter("allowOrigins"));
        this.allowMethods = ConfigUtil.parseParam(config.getInitParameter("allowMethods"));
        this.allowHeaders = ConfigUtil.parseParam(config.getInitParameter("allowHeaders"));
        this.maxAge = ConfigUtil.getIntParam(config.getInitParameter("maxAge"), -1);
        this.supportCredentials = ConfigUtil.getBooleanParam(config.getInitParameter("supportCredentials"), false);
        this.exposeHeaderStr = ConfigUtil.formatListParam(config.getInitParameter("exposeHeaders"));
        this.checkReferer = ConfigUtil.getBooleanParam(config.getInitParameter("checkReferer"), false);
        this.allowOriginStr = ConfigUtil.composeString(this.allowOrigins, ",");
        this.allowMethodStr = ConfigUtil.composeString(this.allowMethods, ",");
        this.allowHeaderStr = ConfigUtil.composeString(this.allowHeaders, ",");
    }

    private void doOptions(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String origin = req.getHeader("Origin");
        if (origin == null && this.checkReferer && this.checkCrossOriginByReferer(req)) {
            origin = CrossOriginUtil.parseHostFromUrl(req.getHeader("referer"));
        }
        if (origin == null || origin.trim().equalsIgnoreCase("null")) {
            logger.info((Object)"Skip empty origin request for OPTIONS.");
            this.skip(req, resp, chain);
            return;
        }
        if (!CrossOriginUtil.match(origin, this.allowOrigins, true)) {
            logger.info((Object)("Refuse invalid Origin request for OPTIONS. Origin:" + origin));
            this.refuse(req, resp, chain);
            return;
        }
        String method = req.getHeader("Access-Control-Request-Method");
        if (method == null) {
            logger.info((Object)"Skip empty Access-Control-Request-Method request for OPTIONS.");
            this.skip(req, resp, chain);
            return;
        }
        if (!CrossOriginUtil.match(method, this.allowMethods, true)) {
            logger.info((Object)("Refuse invalid Access-Control-Request-Method Request for OPTIONS. Method:" + origin));
            this.refuse(req, resp, chain);
            return;
        }
        String acrHeaders = req.getHeader("Access-Control-Request-Headers");
        if (!this.checkACRHeaders(acrHeaders)) {
            logger.info((Object)("Refuse invalid Access-Control-Request-Headers for OPTIONS. Headers:" + acrHeaders));
            this.refuse(req, resp, chain);
            return;
        }
        this.addAllowHeaders(origin, method, acrHeaders, resp);
        if (this.maxAge > 0) {
            resp.setHeader("Access-Control-Max-Age", Integer.toString(this.maxAge));
        }
        resp.setStatus(200);
        resp.setContentLength(1);
        PrintWriter out = resp.getWriter();
        out.println(" ");
        out.flush();
    }

    private void doRequest(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String origin = req.getHeader("Origin");
        if (origin == null && this.checkReferer && this.checkCrossOriginByReferer(req)) {
            origin = CrossOriginUtil.parseHostFromUrl(req.getHeader("referer"));
        }
        if (origin == null || origin.trim().equalsIgnoreCase("null")) {
            logger.warn((Object)"Skip empty origin request.");
            this.skip(req, resp, chain);
            return;
        }
        if (!CrossOriginUtil.match(origin, this.allowOrigins, true)) {
            logger.error((Object)("Refuse invalid origin request. origin:" + origin));
            this.refuse(req, resp, chain);
            return;
        }
        this.addAllowHeaders(origin, null, null, resp);
        if (this.hasExposeHeader()) {
            resp.addHeader("Access-Control-Expose-Header", this.exposeHeaderStr);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private boolean checkACRHeaders(String headerNames) {
        String[] ts;
        if (headerNames == null || headerNames.trim().length() == 0) {
            return true;
        }
        String[] stringArray = ts = headerNames.split("\\s*,\\s*");
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (!CrossOriginUtil.match(t, this.allowHeaders, false)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addAllowHeaders(String origin, String method, String headers, HttpServletResponse resp) {
        if (this.supportCredentials) {
            resp.setHeader("Access-Control-Allow-Origin", origin);
            resp.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            resp.setHeader("Access-Control-Allow-Origin", this.allowOriginStr);
        }
        if (method != null) {
            resp.setHeader("Access-Control-Allow-Methods", method);
        } else {
            resp.setHeader("Access-Control-Allow-Methods", this.allowMethodStr);
        }
        if (headers != null) {
            resp.setHeader("Access-Control-Allow-Headers", headers);
        } else {
            resp.setHeader("Access-Control-Allow-Headers", this.allowHeaderStr);
        }
    }

    private boolean hasExposeHeader() {
        return this.exposeHeaderStr != null && this.exposeHeaderStr.length() > 0;
    }

    private void skip(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void refuse(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        resp.setStatus(200);
        resp.addHeader("Access-Control-Allow-Origin", "");
        resp.setContentLength(1);
        PrintWriter out = resp.getWriter();
        out.println(" ");
        out.flush();
    }

    private boolean checkCrossOriginByReferer(HttpServletRequest req) {
        String referer = req.getHeader("Referer");
        String host = req.getHeader("Host");
        if (referer == null || referer.trim().length() == 0 || host == null || host.trim().length() == 0) {
            return false;
        }
        return !referer.startsWith(host);
    }
}

