/*
 * Decompiled with CFR 0.152.
 */
package com.netease.wd.crossorigin.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrossOriginUtil {
    private static Pattern ptn = Pattern.compile("(http\\:\\/\\/[^:\\/]+(\\:\\d+)?)");

    public static boolean match(String value, List<String> allows, boolean caseSensitive) {
        if (allows == null || allows.size() == 0) {
            return false;
        }
        for (String allow : allows) {
            if (allow.equals("*")) {
                return true;
            }
            if (!(!caseSensitive ? allow.equalsIgnoreCase(value) : allow.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static String parseHostFromUrl(String referer) {
        if (referer == null || referer.length() == 0) {
            return null;
        }
        Matcher m = ptn.matcher(referer);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

