package com.netease.wd.crossorigin.utils;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 配合nej框架实现CORS兼容的工具类。
 * 
 * @author zhouyongchang(zhouyongchang@corp.netease.com)
 */
public class CORSResponseUtil {

	/**
	 * form代理响应模板
	 */
	// TODO: 模板增多后可以迁移出去做个统一的工具类管理
	private static final String TMPL_PROXY_FORM = "<html><body><script>window.result='%1$s';</script><script>var _result='NEJ-UPLOAD-RESULT:{\"key\":\"'+window.name+'\",\"result\":\"'+encodeURIComponent(result)+'\"}';if (window.postMessage){parent.postMessage(_result,'*');}else{_result = '\"'+_result.replace(/\"/g,'\\\"')+'\"';parent.name = escape('MSG|data='+encodeURIComponent(_result));}</script></body></html>";

	/**
	 * 返回内容给客户端。
	 * nej框架为兼容不同的浏览器，需要对响应进行不同的处理。
	 * 对于支持CORS的浏览器，服务器只需要返回json字符串即可；
	 * 对于不支持CORS的浏览器，服务器需要返回特定格式的html页面内容。
	 * 本工具方法对nej的响应内容逻辑进行了封装，应用程序只需传递响应的json字符串即可。
	 * 
	 * @param request servelt request对象
	 * @param response servlet response对象
	 * @param content 待返回给客户端的json字符串
	 * @throws IOException
	 */
	public static void response(HttpServletRequest request,
			HttpServletResponse response, String content) throws IOException {
		String ctype = "application/json";
		if (isProxyForm(request)) {
			//特殊字符的转义
			content = content.replaceAll("\\\\", "\\\\\\\\");
			content = content.replaceAll("\\'", "\\\\'");
			content = String.format(TMPL_PROXY_FORM, content);
			ctype = "text/html";
		}
		response.setContentType(ctype);
		PrintWriter out = response.getWriter();
		out.write(content);
		out.flush();
	}

	/**
	 * 判断是否是form代理的请求
	 * 
	 * @param request
	 * @return
	 */
	private static boolean isProxyForm(HttpServletRequest request) {
		String pstr = request.getParameter("_proxy_");
		return (pstr != null && pstr.equals("form"));
	}
}
