package com.netease.wd.crossorigin.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * 配置工具类
 * 
 * @author zhouyongchang(zhouyongchang@corp.netease.com)
 */
public class ConfigUtil {

	/**
	 * 解析filter初始化参数，返回参数列表。 初始化参数字符串格式："paramA, paramB, ..." 如果参数字符串为空，返回一个空列表。
	 * 
	 * @param params
	 *            初始化参数字符串
	 * @return
	 */
	public static List<String> parseParam(String params) {
		List<String> res = new LinkedList<String>();
		if (params == null || params.trim().length() == 0) {
			return res;
		}

		String[] ts = params.split("\\s*\\,\\s*");

		for (String t : ts) {
			if (t.equals("*")) {
				res.add("*");
				return res;
			}
		}

		Collections.addAll(res, ts);
		return res;
	}

	/**
	 * 解析int型初始化参数。 如果参数字符串为空或非法返回defaultValue。
	 * 
	 * @param param
	 * @param defaultValue
	 * @return
	 */
	public static int getIntParam(String param, int defaultValue) {
		if (param == null) {
			return defaultValue;
		}
		try {
			return Integer.parseInt(param);
		} catch (Exception e) {
			return defaultValue;
		}
	}

	/**
	 * 解析boolean型初始化参数。 如果参数字符串为空或非法返回defaultValue。
	 * 
	 * @param param
	 * @param defaultValue
	 * @return
	 */
	public static boolean getBooleanParam(String param, boolean defaultValue) {
		if (param == null) {
			return defaultValue;
		}
		try {
			return Boolean.parseBoolean(param);
		} catch (Exception e) {
			return defaultValue;
		}
	}

	/**
	 * 解析String型初始化参数。 如果参数字符串为空或非法返回defaultValue。
	 * 
	 * @param param
	 * @param defaultValue
	 * @return
	 */
	public static String getStringParam(String param, String defaultValue) {
		if (param == null) {
			return defaultValue;
		}
		return param;
	}

	/**
	 * 将字符串列表组装成一个字符串。
	 * 
	 * @param params
	 *            字符串列表
	 * @param sep
	 *            分隔符
	 * @return
	 */
	public static String composeString(List<String> params, String sep) {
		if (params == null || params.size() == 0) {
			return "";
		}

		StringBuilder sb = new StringBuilder();
		for (String param : params) {
			if (sb.length() > 0) {
				sb.append(sep);
			}
			sb.append(param);
		}

		return sb.toString();
	}

	/**
	 * 格式化列表初始化参数。
	 * 
	 * @param params
	 * @return
	 */
	public static String formatListParam(String params) {
		return composeString(parseParam(params), ",");
	}

}
