package com.netease.wd.crossorigin.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * cross origin工具类
 * 
 * @author zhouyongchang(zhouyongchang@corp.netease.com)
 */
public class CrossOriginUtil {
	
	private static Pattern ptn = Pattern.compile("(http\\:\\/\\/[^:\\/]+(\\:\\d+)?)");

	/**
	 * 检查一个字段的值是否与allow字段匹配。
	 * 
	 * @param value 字段值
	 * @param allows allow列表
	 * @param caseSensitive 是否大小写敏感
	 * @return
	 */
	public static boolean match(String value, List<String> allows, boolean caseSensitive) {
		if(allows == null || allows.size() == 0) {
			return false;
		}
		
		for(String allow : allows) {
			if(allow.equals("*")) {
				//always matching
				return true;
			}
			
			if(!caseSensitive) {
				if(allow.equalsIgnoreCase(value)) {
					return true;
				}
			} else {
				if(allow.equals(value)) {
					return true;
				}
			}
		}
		return false;
	}
	
	/**
	 * 从一个完整的url中提取host
	 * 如： 从http://a.b.com:8080/index.html中提取http://a.b.com:8080
	 * 
	 * @param referer
	 * @return
	 */
	public static String parseHostFromUrl(String referer) {
		if(referer == null || referer.length() == 0) {
			return null;
		}
		
		Matcher m = ptn.matcher(referer);
		if(m.find()) {
			return m.group(1);
		}
		return null;
	}
}
