/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.access.ScriptRunner;
import org.snaker.engine.access.dialect.Dialect;
import org.snaker.engine.access.jdbc.JdbcHelper;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.CCOrder;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.HistoryTaskActor;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Surrogate;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.TaskActor;
import org.snaker.engine.entity.WorkItem;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBAccess
implements DBAccess {
    private static final Logger log = LoggerFactory.getLogger(AbstractDBAccess.class);
    protected static final String KEY_SQL = "SQL";
    protected static final String KEY_ARGS = "ARGS";
    protected static final String KEY_TYPE = "TYPE";
    protected static final String KEY_ENTITY = "ENTITY";
    protected static final String KEY_SU = "SU";
    protected static final String SAVE = "SAVE";
    protected static final String UPDATE = "UPDATE";
    protected static final String PROCESS_INSERT = "insert into wf_process (id,name,display_Name,type,instance_Url,state,version,create_Time,creator) values (?,?,?,?,?,?,?,?,?)";
    protected static final String PROCESS_UPDATE = "update wf_process set name=?, display_Name=?,state=?,instance_Url=?,create_Time=?,creator=? where id=? ";
    protected static final String PROCESS_UPDATE_BLOB = "update wf_process set content=? where id=?";
    protected static final String PROCESS_UPDATE_TYPE = "update wf_process set type=? where id=?";
    protected static final String ORDER_INSERT = "insert into wf_order (id,process_Id,creator,create_Time,parent_Id,parent_Node_Name,expire_Time,last_Update_Time,last_Updator,order_No,variable,version) values (?,?,?,?,?,?,?,?,?,?,?,0)";
    protected static final String ORDER_UPDATE = "update wf_order set last_Updator=?, last_Update_Time=?, variable = ?, version = version + 1 where id=? and version = ?";
    protected static final String ORDER_HISTORY_INSERT = "insert into wf_hist_order (id,process_Id,order_State,creator,create_Time,end_Time,parent_Id,expire_Time,order_No,variable) values (?,?,?,?,?,?,?,?,?,?)";
    protected static final String ORDER_HISTORY_UPDATE = "update wf_hist_order set order_State = ?, end_Time = ? where id = ? ";
    protected static final String ORDER_DELETE = "delete from wf_order where id = ?";
    protected static final String CCORDER_INSERT = "insert into wf_cc_order (order_Id, actor_Id, status) values (?, ?, ?)";
    protected static final String CCORDER_UPDATE = "update wf_cc_order set status = ? where order_Id = ? and actor_Id = ?";
    protected static final String CCORDER_DELETE = "delete from wf_cc_order where order_Id = ? and actor_Id = ?";
    protected static final String TASK_INSERT = "insert into wf_task (id,order_Id,task_Name,display_Name,task_Type,perform_Type,operator,create_Time,finish_Time,expire_Time,action_Url,parent_Task_Id,variable,version) values (?,?,?,?,?,?,?,?,?,?,?,?,?,0)";
    protected static final String TASK_UPDATE = "update wf_task set finish_Time=?, operator=?, version = version + 1 where id=? and version = ?";
    protected static final String TASK_HISTORY_INSERT = "insert into wf_hist_task (id,order_Id,task_Name,display_Name,task_Type,perform_Type,task_State,operator,create_Time,finish_Time,expire_Time,action_Url,parent_Task_Id,variable) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String TASK_DELETE = "delete from wf_task where id = ?";
    protected static final String TASK_ACTOR_INSERT = "insert into wf_task_actor (task_Id, actor_Id) values (?, ?)";
    protected static final String TASK_ACTOR_HISTORY_INSERT = "insert into wf_hist_task_actor (task_Id, actor_Id) values (?, ?)";
    protected static final String TASK_ACTOR_DELETE = "delete from wf_task_actor where task_Id = ?";
    protected static final String TASK_ACTOR_REDUCE = "delete from wf_task_actor where task_Id = ? and actor_Id = ?";
    protected static final String QUERY_VERSION = "select max(version) from wf_process ";
    protected static final String QUERY_PROCESS = "select id,name,display_Name,type,instance_Url,state, content, version,create_Time,creator from wf_process ";
    protected static final String QUERY_ORDER = "select o.id,o.process_Id,o.creator,o.create_Time,o.parent_Id,o.parent_Node_Name,o.expire_Time,o.last_Update_Time,o.last_Updator,o.priority,o.order_No,o.variable, o.version from wf_order o ";
    protected static final String QUERY_TASK = "select id,order_Id,task_Name,display_Name,task_Type,perform_Type,operator,create_Time,finish_Time,expire_Time,action_Url,parent_Task_Id,variable, version from wf_task ";
    protected static final String QUERY_TASK_ACTOR = "select task_Id, actor_Id from wf_task_actor ";
    protected static final String QUERY_CCORDER = "select order_Id, actor_Id, status from wf_cc_order ";
    protected static final String QUERY_HIST_ORDER = "select o.id,o.process_Id,o.order_State,o.priority,o.creator,o.create_Time,o.end_Time,o.parent_Id,o.expire_Time,o.order_No,o.variable from wf_hist_order o ";
    protected static final String QUERY_HIST_TASK = "select id,order_Id,task_Name,display_Name,task_Type,perform_Type,task_State,operator,create_Time,finish_Time,expire_Time,action_Url,parent_Task_Id,variable from wf_hist_task ";
    protected static final String QUERY_HIST_TASK_ACTOR = "select task_Id, actor_Id from wf_hist_task_actor ";
    protected static final String SURROGATE_INSERT = "insert into wf_surrogate (id, process_Name, operator, surrogate, odate, sdate, edate, state) values (?,?,?,?,?,?,?,?)";
    protected static final String SURROGATE_UPDATE = "update wf_surrogate set process_Name=?, surrogate=?, odate=?, sdate=?, edate=?, state=? where id = ?";
    protected static final String SURROGATE_DELETE = "delete from wf_surrogate where id = ?";
    protected static final String SURROGATE_QUERY = "select id, process_Name, operator, surrogate, odate, sdate, edate, state from wf_surrogate";
    protected Dialect dialect;

    public abstract boolean isORM();

    public abstract void saveOrUpdate(Map<String, Object> var1);

    @Override
    public void initialize(Object accessObject) {
    }

    private Map<String, Object> buildMap(String sql, Object[] args, int[] type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_SQL, sql);
        map.put(KEY_ARGS, args);
        map.put(KEY_TYPE, type);
        return map;
    }

    private Map<String, Object> buildMap(Object entity, String su) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_ENTITY, entity);
        map.put(KEY_SU, su);
        return map;
    }

    protected Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = ServiceContext.getContext().find(Dialect.class);
        }
        return this.dialect;
    }

    @Override
    public void saveProcess(Process process) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(process, SAVE));
        } else {
            Object[] args = new Object[]{process.getId(), process.getName(), process.getDisplayName(), process.getType(), process.getInstanceUrl(), process.getState(), process.getVersion(), process.getCreateTime(), process.getCreator()};
            int[] type = new int[]{12, 12, 12, 4, 12, 4, 4, 12, 12};
            this.saveOrUpdate(this.buildMap(PROCESS_INSERT, args, type));
        }
    }

    @Override
    public void updateProcess(Process process) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(process, UPDATE));
        } else {
            Object[] args = new Object[]{process.getName(), process.getDisplayName(), process.getState(), process.getInstanceUrl(), process.getCreateTime(), process.getCreator(), process.getId()};
            int[] type = new int[]{12, 12, 4, 12, 12, 12, 12};
            this.saveOrUpdate(this.buildMap(PROCESS_UPDATE, args, type));
        }
    }

    @Override
    public void updateProcessType(String id, String type) {
        if (this.isORM()) {
            Process process = this.getProcess(id);
            process.setType(type);
            this.saveOrUpdate(this.buildMap(process, UPDATE));
        } else {
            Object[] args = new Object[]{type, id};
            int[] types = new int[]{12, 12};
            this.saveOrUpdate(this.buildMap(PROCESS_UPDATE_TYPE, args, types));
        }
    }

    @Override
    public void saveTask(Task task) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(task, SAVE));
        } else {
            Object[] args = new Object[]{task.getId(), task.getOrderId(), task.getTaskName(), task.getDisplayName(), task.getTaskType(), task.getPerformType(), task.getOperator(), task.getCreateTime(), task.getFinishTime(), task.getExpireTime(), task.getActionUrl(), task.getParentTaskId(), task.getVariable()};
            int[] type = new int[]{12, 12, 12, 12, 4, 4, 12, 12, 12, 12, 12, 12, 12};
            this.saveOrUpdate(this.buildMap(TASK_INSERT, args, type));
        }
    }

    @Override
    public void saveOrder(Order order) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(order, SAVE));
        } else {
            Object[] args = new Object[]{order.getId(), order.getProcessId(), order.getCreator(), order.getCreateTime(), order.getParentId(), order.getParentNodeName(), order.getExpireTime(), order.getLastUpdateTime(), order.getLastUpdator(), order.getOrderNo(), order.getVariable()};
            int[] type = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
            this.saveOrUpdate(this.buildMap(ORDER_INSERT, args, type));
        }
    }

    @Override
    public void saveCCOrder(CCOrder ccorder) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(ccorder, SAVE));
        } else {
            int[] type = new int[]{12, 12, 4};
            this.saveOrUpdate(this.buildMap(CCORDER_INSERT, new Object[]{ccorder.getOrderId(), ccorder.getActorId(), ccorder.getStatus()}, type));
        }
    }

    @Override
    public void saveTaskActor(TaskActor taskActor) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(taskActor, SAVE));
        } else {
            int[] type = new int[]{12, 12};
            this.saveOrUpdate(this.buildMap(TASK_ACTOR_INSERT, new Object[]{taskActor.getTaskId(), taskActor.getActorId()}, type));
        }
    }

    @Override
    public void updateTask(Task task) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(task, UPDATE));
        } else {
            Object[] args = new Object[]{task.getFinishTime(), task.getOperator(), task.getId(), task.getVersion()};
            int[] type = new int[]{12, 12, 12, 4};
            this.saveOrUpdate(this.buildMap(TASK_UPDATE, args, type));
        }
    }

    @Override
    public void updateOrder(Order order) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(order, UPDATE));
        } else {
            Object[] args = new Object[]{order.getLastUpdator(), order.getLastUpdateTime(), order.getVariable(), order.getId(), order.getVersion()};
            int[] type = new int[]{12, 12, 12, 12, 4};
            this.saveOrUpdate(this.buildMap(ORDER_UPDATE, args, type));
        }
    }

    @Override
    public void updateCCOrder(CCOrder ccorder) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(ccorder, UPDATE));
        } else {
            Object[] args = new Object[]{ccorder.getStatus(), ccorder.getOrderId(), ccorder.getActorId()};
            int[] type = new int[]{4, 12, 12};
            this.saveOrUpdate(this.buildMap(CCORDER_UPDATE, args, type));
        }
    }

    @Override
    public void deleteTask(Task task) {
        if (!this.isORM()) {
            Object[] args = new Object[]{task.getId()};
            int[] type = new int[]{12};
            this.saveOrUpdate(this.buildMap(TASK_ACTOR_DELETE, args, type));
            this.saveOrUpdate(this.buildMap(TASK_DELETE, args, type));
        }
    }

    @Override
    public void deleteOrder(Order order) {
        if (!this.isORM()) {
            int[] type = new int[]{12};
            this.saveOrUpdate(this.buildMap(ORDER_DELETE, new Object[]{order.getId()}, type));
        }
    }

    @Override
    public void deleteCCOrder(CCOrder ccorder) {
        if (!this.isORM()) {
            int[] type = new int[]{12, 12};
            this.saveOrUpdate(this.buildMap(CCORDER_DELETE, new Object[]{ccorder.getOrderId(), ccorder.getActorId()}, type));
        }
    }

    @Override
    public void removeTaskActor(String taskId, String ... actors) {
        if (!this.isORM()) {
            for (String actorId : actors) {
                int[] type = new int[]{12, 12};
                this.saveOrUpdate(this.buildMap(TASK_ACTOR_REDUCE, new Object[]{taskId, actorId}, type));
            }
        }
    }

    @Override
    public void saveHistory(HistoryOrder order) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(order, SAVE));
        } else {
            Object[] args = new Object[]{order.getId(), order.getProcessId(), order.getOrderState(), order.getCreator(), order.getCreateTime(), order.getEndTime(), order.getParentId(), order.getExpireTime(), order.getOrderNo(), order.getVariable()};
            int[] type = new int[]{12, 12, 4, 12, 12, 12, 12, 12, 12, 12};
            this.saveOrUpdate(this.buildMap(ORDER_HISTORY_INSERT, args, type));
        }
    }

    @Override
    public void updateHistory(HistoryOrder order) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(order, UPDATE));
        } else {
            Object[] args = new Object[]{order.getOrderState(), order.getEndTime(), order.getId()};
            int[] type = new int[]{4, 12, 12};
            this.saveOrUpdate(this.buildMap(ORDER_HISTORY_UPDATE, args, type));
        }
    }

    @Override
    public void saveHistory(HistoryTask task) {
        block4: {
            block3: {
                if (!this.isORM()) break block3;
                this.saveOrUpdate(this.buildMap(task, SAVE));
                if (task.getActorIds() == null) break block4;
                for (String actorId : task.getActorIds()) {
                    if (StringHelper.isEmpty(actorId)) continue;
                    HistoryTaskActor hist = new HistoryTaskActor();
                    hist.setActorId(actorId);
                    hist.setTaskId(task.getId());
                    this.saveOrUpdate(this.buildMap(hist, SAVE));
                }
                break block4;
            }
            Object[] args = new Object[]{task.getId(), task.getOrderId(), task.getTaskName(), task.getDisplayName(), task.getTaskType(), task.getPerformType(), task.getTaskState(), task.getOperator(), task.getCreateTime(), task.getFinishTime(), task.getExpireTime(), task.getActionUrl(), task.getParentTaskId(), task.getVariable()};
            int[] type = new int[]{12, 12, 12, 12, 4, 4, 4, 12, 12, 12, 12, 12, 12, 12};
            this.saveOrUpdate(this.buildMap(TASK_HISTORY_INSERT, args, type));
            if (task.getActorIds() != null) {
                for (String actorId : task.getActorIds()) {
                    if (StringHelper.isEmpty(actorId)) continue;
                    this.saveOrUpdate(this.buildMap(TASK_ACTOR_HISTORY_INSERT, new Object[]{task.getId(), actorId}, new int[]{12, 12}));
                }
            }
        }
    }

    @Override
    public void saveSurrogate(Surrogate surrogate) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(surrogate, SAVE));
        } else {
            Object[] args = new Object[]{surrogate.getId(), surrogate.getProcessName(), surrogate.getOperator(), surrogate.getSurrogate(), surrogate.getOdate(), surrogate.getSdate(), surrogate.getEdate(), surrogate.getState()};
            int[] type = new int[]{12, 12, 12, 12, 12, 12, 12, 4};
            this.saveOrUpdate(this.buildMap(SURROGATE_INSERT, args, type));
        }
    }

    @Override
    public void updateSurrogate(Surrogate surrogate) {
        if (this.isORM()) {
            this.saveOrUpdate(this.buildMap(surrogate, UPDATE));
        } else {
            Object[] args = new Object[]{surrogate.getProcessName(), surrogate.getSurrogate(), surrogate.getOdate(), surrogate.getSdate(), surrogate.getEdate(), surrogate.getState(), surrogate.getId()};
            int[] type = new int[]{12, 12, 12, 12, 12, 4, 12};
            this.saveOrUpdate(this.buildMap(SURROGATE_UPDATE, args, type));
        }
    }

    @Override
    public void deleteSurrogate(Surrogate surrogate) {
        if (!this.isORM()) {
            Object[] args = new Object[]{surrogate.getId()};
            int[] type = new int[]{12};
            this.saveOrUpdate(this.buildMap(SURROGATE_DELETE, args, type));
        }
    }

    @Override
    public Surrogate getSurrogate(String id) {
        String where = " where id = ?";
        return this.queryObject(Surrogate.class, SURROGATE_QUERY + where, id);
    }

    @Override
    public List<Surrogate> getSurrogate(Page<Surrogate> page, QueryFilter filter) {
        StringBuffer sql = new StringBuffer(SURROGATE_QUERY);
        sql.append(" where 1=1 and state = 1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and process_Name in(");
            for (int i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and operator in (");
            for (String actor : filter.getOperators()) {
                sql.append("?,");
                paramList.add(actor);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getOperateTime())) {
            sql.append(" and sdate <= ? and edate >= ? ");
            paramList.add(filter.getOperateTime());
            paramList.add(filter.getOperateTime());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("sdate");
        }
        return this.queryList(page, filter, Surrogate.class, sql.toString(), paramList.toArray());
    }

    @Override
    public Task getTask(String taskId) {
        String where = " where id = ?";
        return this.queryObject(Task.class, QUERY_TASK + where, taskId);
    }

    @Override
    public List<Task> getNextActiveTasks(String parentTaskId) {
        String where = " where parent_Task_Id = ?";
        return this.queryList(Task.class, QUERY_TASK + where, parentTaskId);
    }

    @Override
    public List<Task> getNextActiveTasks(String orderId, String taskName, String parentTaskId) {
        StringBuffer sql = new StringBuffer(QUERY_TASK);
        sql.append(" where parent_task_id in ( ");
        sql.append("select ht.id from wf_hist_task ht where ht.order_id=? and ht.task_name=? and ht.parent_task_id=? ");
        sql.append(")");
        return this.queryList(Task.class, sql.toString(), orderId, taskName, parentTaskId);
    }

    @Override
    public HistoryTask getHistTask(String taskId) {
        String where = " where id = ?";
        return this.queryObject(HistoryTask.class, QUERY_HIST_TASK + where, taskId);
    }

    @Override
    public HistoryOrder getHistOrder(String orderId) {
        String where = " where o.id = ?";
        return this.queryObject(HistoryOrder.class, QUERY_HIST_ORDER + where, orderId);
    }

    @Override
    public List<TaskActor> getTaskActorsByTaskId(String taskId) {
        String where = " where task_Id = ?";
        return this.queryList(TaskActor.class, QUERY_TASK_ACTOR + where, taskId);
    }

    @Override
    public List<HistoryTaskActor> getHistTaskActorsByTaskId(String taskId) {
        String where = " where task_Id = ?";
        return this.queryList(HistoryTaskActor.class, QUERY_HIST_TASK_ACTOR + where, taskId);
    }

    @Override
    public Order getOrder(String orderId) {
        String where = " where o.id = ?";
        return this.queryObject(Order.class, QUERY_ORDER + where, orderId);
    }

    @Override
    public List<CCOrder> getCCOrder(String orderId, String ... actorIds) {
        StringBuffer where = new StringBuffer(QUERY_CCORDER);
        where.append(" where status = 1 and order_Id = ? ");
        where.append(" and actor_Id in (");
        where.append(StringUtils.repeat((String)"?,", (int)actorIds.length));
        where.deleteCharAt(where.length() - 1);
        where.append(") ");
        return this.queryList(CCOrder.class, where.toString(), ArrayUtils.add((Object[])actorIds, (int)0, (Object)orderId));
    }

    @Override
    public Process getProcess(String id) {
        String where = " where id = ?";
        return this.queryObject(Process.class, QUERY_PROCESS + where, id);
    }

    @Override
    public List<Process> getProcesss(Page<Process> page, QueryFilter filter) {
        int i;
        StringBuffer sql = new StringBuffer(QUERY_PROCESS);
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and name in(");
            for (i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getVersion() != null) {
            sql.append(" and version = ? ");
            paramList.add(filter.getVersion());
        }
        if (filter.getState() != null) {
            sql.append(" and state = ? ");
            paramList.add(filter.getState());
        }
        if (StringHelper.isNotEmpty(filter.getDisplayName())) {
            sql.append(" and display_Name like ? ");
            paramList.add("%" + filter.getDisplayName() + "%");
        }
        if (StringHelper.isNotEmpty(filter.getProcessType())) {
            sql.append(" and type = ? ");
            paramList.add(filter.getProcessType());
        }
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and creator in(");
            for (i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("asc");
            filter.setOrderBy("name");
        }
        return this.queryList(page, filter, Process.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<Order> getActiveOrders(Page<Order> page, QueryFilter filter) {
        int i;
        StringBuffer sql = new StringBuffer(QUERY_ORDER);
        sql.append(" left join wf_process p on p.id = o.process_id ");
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and o.creator in(");
            for (i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and p.name in(");
            for (i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getProcessId())) {
            sql.append(" and o.process_Id = ? ");
            paramList.add(filter.getProcessId());
        }
        if (StringHelper.isNotEmpty(filter.getProcessType())) {
            sql.append(" and p.type = ? ");
            paramList.add(filter.getProcessType());
        }
        if (StringHelper.isNotEmpty(filter.getParentId())) {
            sql.append(" and o.parent_Id = ? ");
        }
        if (filter.getExcludedIds() != null && filter.getExcludedIds().length > 0) {
            sql.append(" and o.id not in(");
            for (i = 0; i < filter.getExcludedIds().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getExcludedIds()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and o.create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and o.create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (StringHelper.isNotEmpty(filter.getOrderNo())) {
            sql.append(" and o.order_No = ? ");
            paramList.add(filter.getOrderNo());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("o.create_Time");
        }
        return this.queryList(page, filter, Order.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<Task> getActiveTasks(Page<Task> page, QueryFilter filter) {
        int i;
        boolean isFetchActor;
        StringBuffer sql = new StringBuffer(QUERY_TASK);
        boolean bl = isFetchActor = filter.getOperators() != null && filter.getOperators().length > 0;
        if (isFetchActor) {
            sql.append(" left join wf_task_actor ta on ta.task_id = id ");
        }
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringHelper.isNotEmpty(filter.getOrderId())) {
            sql.append(" and order_Id = ? ");
            paramList.add(filter.getOrderId());
        }
        if (filter.getExcludedIds() != null && filter.getExcludedIds().length > 0) {
            sql.append(" and id not in(");
            for (i = 0; i < filter.getExcludedIds().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getExcludedIds()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (isFetchActor) {
            sql.append(" and ta.actor_Id in (");
            for (i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and task_Name in (");
            for (i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("create_Time");
        }
        return this.queryList(page, filter, Task.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<HistoryOrder> getHistoryOrders(Page<HistoryOrder> page, QueryFilter filter) {
        int i;
        StringBuffer sql = new StringBuffer(QUERY_HIST_ORDER);
        sql.append(" left join wf_process p on p.id = o.process_id ");
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and o.creator in(");
            for (i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and p.name in(");
            for (i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getProcessId())) {
            sql.append(" and o.process_Id = ? ");
            paramList.add(filter.getProcessId());
        }
        if (StringHelper.isNotEmpty(filter.getProcessType())) {
            sql.append(" and p.type = ? ");
            paramList.add(filter.getProcessType());
        }
        if (StringHelper.isNotEmpty(filter.getParentId())) {
            sql.append(" and o.parent_Id = ? ");
            paramList.add(filter.getParentId());
        }
        if (filter.getState() != null) {
            sql.append(" and o.order_State = ? ");
            paramList.add(filter.getState());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and o.create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and o.create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (StringHelper.isNotEmpty(filter.getOrderNo())) {
            sql.append(" and o.order_No = ? ");
            paramList.add(filter.getOrderNo());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("o.create_Time");
        }
        return this.queryList(page, filter, HistoryOrder.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<HistoryTask> getHistoryTasks(Page<HistoryTask> page, QueryFilter filter) {
        int i;
        boolean isFetchActor;
        StringBuffer sql = new StringBuffer(QUERY_HIST_TASK);
        boolean bl = isFetchActor = filter.getOperators() != null && filter.getOperators().length > 0;
        if (isFetchActor) {
            sql.append(" left join wf_hist_task_actor ta on ta.task_id = id ");
        }
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringHelper.isNotEmpty(filter.getOrderId())) {
            sql.append(" and order_Id = ? ");
            paramList.add(filter.getOrderId());
        }
        if (isFetchActor) {
            sql.append(" and ta.actor_Id in (");
            for (i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getNames() != null && filter.getNames().length > 0) {
            sql.append(" and task_Name in (");
            for (i = 0; i < filter.getNames().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getNames()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("finish_Time");
        }
        return this.queryList(page, filter, HistoryTask.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<WorkItem> getWorkItems(Page<WorkItem> page, QueryFilter filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select o.process_Id, t.order_Id, t.id as id, t.id as task_Id, p.display_Name as process_Name, p.instance_Url, o.parent_Id, o.creator, ");
        sql.append(" o.create_Time as order_Create_Time, o.expire_Time as order_Expire_Time, o.order_No, o.variable as order_Variable, ");
        sql.append(" t.display_Name as task_Name, t.task_Type, t.perform_Type, t.operator, t.action_Url, ");
        sql.append(" t.create_Time as task_Create_Time, t.finish_Time as task_End_Time, t.expire_Time as task_Expire_Time, t.variable as task_Variable ");
        sql.append(" from wf_task t ");
        sql.append(" left join wf_order o on t.order_id = o.id ");
        sql.append(" left join wf_task_actor ta on ta.task_id=t.id ");
        sql.append(" left join wf_process p on p.id = o.process_id ");
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and ta.actor_Id in (");
            for (String actor : filter.getOperators()) {
                sql.append("?,");
                paramList.add(actor);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getProcessId())) {
            sql.append(" and o.process_Id = ?");
            paramList.add(filter.getProcessId());
        }
        if (StringHelper.isNotEmpty(filter.getParentId())) {
            sql.append(" and o.parent_Id = ? ");
            paramList.add(filter.getParentId());
        }
        if (filter.getTaskType() != null) {
            sql.append(" and t.task_Type = ? ");
            paramList.add(filter.getTaskType());
        }
        if (filter.getPerformType() != null) {
            sql.append(" and t.perform_Type = ? ");
            paramList.add(filter.getPerformType());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and t.create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and t.create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("t.create_Time");
        }
        return this.queryList(page, filter, WorkItem.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<HistoryOrder> getCCWorks(Page<HistoryOrder> page, QueryFilter filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select id,process_Id,order_State,priority,creator,create_Time,end_Time,parent_Id,expire_Time,order_No,variable ");
        sql.append(" from wf_cc_order cc ");
        sql.append(" left join wf_hist_order o on cc.order_id = o.id ");
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and cc.actor_Id in(");
            for (int i = 0; i < filter.getOperators().length; ++i) {
                sql.append("?,");
                paramList.add(filter.getOperators()[i]);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (filter.getState() != null) {
            sql.append(" and cc.status = ? ");
            paramList.add(filter.getState());
        }
        if (StringHelper.isNotEmpty(filter.getProcessId())) {
            sql.append(" and process_Id = ? ");
            paramList.add(filter.getProcessId());
        }
        if (StringHelper.isNotEmpty(filter.getParentId())) {
            sql.append(" and parent_Id = ? ");
            paramList.add(filter.getParentId());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (StringHelper.isNotEmpty(filter.getOrderNo())) {
            sql.append(" and order_No = ? ");
            paramList.add(filter.getOrderNo());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("create_Time");
        }
        return this.queryList(page, filter, HistoryOrder.class, sql.toString(), paramList.toArray());
    }

    @Override
    public List<WorkItem> getHistoryWorkItems(Page<WorkItem> page, QueryFilter filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select o.process_Id, t.order_Id, t.id as id, t.id as task_Id, p.display_Name as process_Name, p.instance_Url, o.parent_Id, o.creator, ");
        sql.append(" o.create_Time as order_Create_Time, o.expire_Time as order_Expire_Time, o.order_No, o.variable as order_Variable, ");
        sql.append(" t.display_Name as task_Name, t.task_Type, t.perform_Type,t.operator, t.action_Url, ");
        sql.append(" t.create_Time as task_Create_Time, t.finish_Time as task_End_Time, t.expire_Time as task_Expire_Time, t.variable as task_Variable ");
        sql.append(" from wf_hist_task t ");
        sql.append(" left join wf_hist_order o on t.order_id = o.id ");
        sql.append(" left join wf_hist_task_actor ta on ta.task_id=t.id ");
        sql.append(" left join wf_process p on p.id = o.process_id ");
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (filter.getOperators() != null && filter.getOperators().length > 0) {
            sql.append(" and ta.actor_Id in (");
            for (String actor : filter.getOperators()) {
                sql.append("?,");
                paramList.add(actor);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") ");
        }
        if (StringHelper.isNotEmpty(filter.getProcessId())) {
            sql.append(" and o.process_Id = ?");
            paramList.add(filter.getProcessId());
        }
        if (StringHelper.isNotEmpty(filter.getParentId())) {
            sql.append(" and o.parent_Id = ? ");
            paramList.add(filter.getParentId());
        }
        if (filter.getTaskType() != null) {
            sql.append(" and t.task_Type = ? ");
            paramList.add(filter.getTaskType());
        }
        if (filter.getPerformType() != null) {
            sql.append(" and t.perform_Type = ? ");
            paramList.add(filter.getPerformType());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeStart())) {
            sql.append(" and t.create_Time >= ? ");
            paramList.add(filter.getCreateTimeStart());
        }
        if (StringHelper.isNotEmpty(filter.getCreateTimeEnd())) {
            sql.append(" and t.create_Time <= ? ");
            paramList.add(filter.getCreateTimeEnd());
        }
        if (!filter.isOrderBySetted()) {
            filter.setOrder("desc");
            filter.setOrderBy("t.create_Time");
        }
        return this.queryList(page, filter, WorkItem.class, sql.toString(), paramList.toArray());
    }

    @Override
    public <T> List<T> queryList(Page<T> page, QueryFilter filter, Class<T> clazz, String sql, Object ... args) {
        String orderby = StringHelper.buildPageOrder(filter.getOrder(), filter.getOrderBy());
        String querySQL = sql + orderby;
        if (page == null) {
            return this.queryList(clazz, querySQL, args);
        }
        String countSQL = "select count(1) from (" + sql + ") c ";
        querySQL = this.getDialect().getPageSql(querySQL, page);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5206\u9875countSQL=\n" + countSQL);
            log.debug("\u67e5\u8be2\u5206\u9875querySQL=\n" + querySQL);
        }
        try {
            Object count = this.queryCount(countSQL, args);
            List<T> list = this.queryList(clazz, querySQL, args);
            if (list == null) {
                list = Collections.emptyList();
            }
            page.setResult(list);
            page.setTotalCount(ClassHelper.castLong(count));
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void runScript() {
        String autoStr = ConfigHelper.getProperty("schema.auto");
        if (autoStr == null || !autoStr.equalsIgnoreCase("true")) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (JdbcHelper.isExec(conn)) {
                log.info("script has completed execution.skip this step");
                return;
            }
            String databaseType = JdbcHelper.getDatabaseType(conn);
            String schema = "db/core/schema-" + databaseType + ".sql";
            ScriptRunner runner = new ScriptRunner(conn, true);
            runner.runScript(schema);
        }
        catch (Exception e) {
            throw new SnakerException(e);
        }
        finally {
            try {
                JdbcHelper.close(conn);
            }
            catch (SQLException e) {}
        }
    }

    protected abstract Object queryCount(String var1, Object ... var2);

    protected abstract Connection getConnection() throws SQLException;
}

