/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.AbstractDBAccess;
import org.snaker.engine.access.jdbc.BeanPropertyHandler;
import org.snaker.engine.access.jdbc.JdbcHelper;
import org.snaker.engine.entity.Process;
import org.snaker.engine.helper.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAccess
extends AbstractDBAccess
implements DBAccess {
    private static final Logger log = LoggerFactory.getLogger(JdbcAccess.class);
    private QueryRunner runner = new QueryRunner();
    protected DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initialize(Object accessObject) {
        if (accessObject == null) {
            return;
        }
        if (accessObject instanceof DataSource) {
            this.dataSource = (DataSource)accessObject;
        }
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return JdbcHelper.getConnection(this.dataSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveProcess(Process process) {
        super.saveProcess(process);
        if (process.getBytes() == null) return;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("update wf_process set content=? where id=?");
            pstmt.setBytes(1, process.getBytes());
            pstmt.setString(2, process.getId());
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                throw new SnakerException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                try {
                    JdbcHelper.close(pstmt);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new SnakerException(e2.getMessage(), e2.getCause());
                }
            }
        }
        try {
            JdbcHelper.close(pstmt);
            return;
        }
        catch (SQLException e) {
            throw new SnakerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateProcess(Process process) {
        super.updateProcess(process);
        if (process.getBytes() == null) return;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("update wf_process set content=? where id=?");
            pstmt.setBytes(1, process.getBytes());
            pstmt.setString(2, process.getId());
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                throw new SnakerException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                try {
                    JdbcHelper.close(pstmt);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new SnakerException(e2.getMessage(), e2.getCause());
                }
            }
        }
        try {
            JdbcHelper.close(pstmt);
            return;
        }
        catch (SQLException e) {
            throw new SnakerException(e.getMessage(), e.getCause());
        }
    }

    public Object query(int column, String sql, Object ... params) {
        Object result;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u5355\u5217\u6570\u636e=\n" + sql);
            }
            result = this.runner.query(this.getConnection(), sql, (ResultSetHandler)new ScalarHandler(column), params);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Integer getLatestProcessVersion(String name) {
        String where = " where name = ?";
        Object result = this.query(1, "select max(version) from wf_process " + where, name);
        return new Long(ClassHelper.castLong(result)).intValue();
    }

    @Override
    public boolean isORM() {
        return false;
    }

    @Override
    public void saveOrUpdate(Map<String, Object> map) {
        String sql = (String)map.get("SQL");
        Object[] args = (Object[])map.get("ARGS");
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u589e\u5220\u6539\u6570\u636e(\u9700\u624b\u52a8\u63d0\u4ea4\u4e8b\u52a1)=\n" + sql);
            }
            this.runner.update(this.getConnection(), sql, args);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T queryObject(Class<T> clazz, String sql, Object ... args) {
        List result = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u5355\u6761\u8bb0\u5f55=\n" + sql);
            }
            result = (List)this.runner.query(this.getConnection(), sql, new BeanPropertyHandler<T>(clazz), args);
            return JdbcHelper.requiredSingleResult(result);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> List<T> queryList(Class<T> clazz, String sql, Object ... args) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u591a\u6761\u8bb0\u5f55=\n" + sql);
            }
            return (List)this.runner.query(this.getConnection(), sql, new BeanPropertyHandler<T>(clazz), args);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Object queryCount(String sql, Object ... args) {
        return this.query(1, sql, args);
    }
}

