/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.jdbc;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdbcHelper {
    private static DataSource dataSource = null;
    private static Properties databaseTypeMappings = JdbcHelper.getDefaultDatabaseTypeMappings();

    private static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", "h2");
        databaseTypeMappings.setProperty("MySQL", "mysql");
        databaseTypeMappings.setProperty("Oracle", "oracle");
        databaseTypeMappings.setProperty("PostgreSQL", "postgres");
        databaseTypeMappings.setProperty("Microsoft SQL Server", "mssql");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2/NT", "db2");
        databaseTypeMappings.setProperty("DB2/NT64", "db2");
        databaseTypeMappings.setProperty("DB2 UDP", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX390", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXX8664", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXZ64", "db2");
        databaseTypeMappings.setProperty("DB2/400 SQL", "db2");
        databaseTypeMappings.setProperty("DB2/6000", "db2");
        databaseTypeMappings.setProperty("DB2 UDB iSeries", "db2");
        databaseTypeMappings.setProperty("DB2/AIX64", "db2");
        databaseTypeMappings.setProperty("DB2/HPUX", "db2");
        databaseTypeMappings.setProperty("DB2/HP64", "db2");
        databaseTypeMappings.setProperty("DB2/SUN", "db2");
        databaseTypeMappings.setProperty("DB2/SUN64", "db2");
        databaseTypeMappings.setProperty("DB2/PTX", "db2");
        databaseTypeMappings.setProperty("DB2/2", "db2");
        return databaseTypeMappings;
    }

    private static void initialize() {
        String driver = ConfigHelper.getProperty("jdbc.driver");
        String url = ConfigHelper.getProperty("jdbc.url");
        String username = ConfigHelper.getProperty("jdbc.username");
        String password = ConfigHelper.getProperty("jdbc.password");
        int maxActive = ConfigHelper.getNumerProperty("jdbc.max.active");
        int maxIdle = ConfigHelper.getNumerProperty("jdbc.max.idle");
        AssertHelper.notNull(driver);
        AssertHelper.notNull(url);
        AssertHelper.notNull(username);
        AssertHelper.notNull(password);
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(driver);
        ds.setUrl(url);
        ds.setUsername(username);
        ds.setPassword(password);
        if (maxActive != 0) {
            ds.setMaxActive(maxActive);
        }
        if (maxIdle != 0) {
            ds.setMaxIdle(maxIdle);
        }
        dataSource = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static DataSource getDataSource() {
        if (dataSource == null) {
            Class<JdbcHelper> clazz = JdbcHelper.class;
            // MONITORENTER : org.snaker.engine.access.jdbc.JdbcHelper.class
            if (dataSource == null) {
                JdbcHelper.initialize();
            }
            // MONITOREXIT : clazz
        }
        AssertHelper.notNull(dataSource);
        return dataSource;
    }

    public static Connection getConnection(DataSource ds) throws SQLException {
        Connection conn = (Connection)TransactionObjectHolder.get();
        if (conn != null) {
            return conn;
        }
        if (ds != null) {
            return ds.getConnection();
        }
        return JdbcHelper.getDataSource().getConnection();
    }

    public static <T> T requiredSingleResult(Collection<T> results) {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        return results.iterator().next();
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static Object getResultSetValue(ResultSet rs, int index, Class<?> requiredType) throws SQLException {
        if (requiredType == null) {
            return JdbcHelper.getResultSetValue(rs, index);
        }
        Object value = null;
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            value = rs.getString(index);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else {
            value = byte[].class.equals(requiredType) ? (Object)rs.getBytes(index) : (Date.class.equals(requiredType) ? rs.getDate(index) : (Time.class.equals(requiredType) ? rs.getTime(index) : (Timestamp.class.equals(requiredType) || java.util.Date.class.equals(requiredType) ? rs.getTimestamp(index) : (BigDecimal.class.equals(requiredType) ? rs.getBigDecimal(index) : (Blob.class.equals(requiredType) ? rs.getBlob(index) : (Clob.class.equals(requiredType) ? rs.getClob(index) : JdbcHelper.getResultSetValue(rs, index)))))));
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static void close(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    public static void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    public static String getDatabaseType(Connection conn) throws Exception {
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        String databaseProductName = databaseMetaData.getDatabaseProductName();
        return databaseTypeMappings.getProperty(databaseProductName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean isExec(Connection conn) {
        stmt = null;
        try {
            sql = ConfigHelper.getProperty("schema.test");
            if (StringHelper.isEmpty(sql)) {
                sql = "select * from wf_process";
            }
            stmt = conn.createStatement();
            stmt.execute(sql);
            var3_4 = true;
            ** try [egrp 1[TRYBLOCK] [0 : 35->42)] { 
        }
        catch (Exception e) {
            var3_5 = false;
            return var3_5;
        }
        finally {
            try {
                JdbcHelper.close(stmt);
            }
            catch (SQLException e) {}
        }
lbl-1000:
        // 1 sources

        {
            JdbcHelper.close(stmt);
        }
lbl13:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return var3_4;
    }
}

