/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.List;
import java.util.Map;
import org.snaker.engine.IOrderService;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.CCOrder;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.JsonHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.ProcessModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderService
extends AccessService
implements IOrderService {
    @Override
    public Order createOrder(Process process, String operator, Map<String, Object> args) {
        return this.createOrder(process, operator, args, null, null);
    }

    @Override
    public Order createOrder(Process process, String operator, Map<String, Object> args, String parentId, String parentNodeName) {
        Order order = new Order();
        order.setId(StringHelper.getPrimaryKey());
        order.setParentId(parentId);
        order.setParentNodeName(parentNodeName);
        order.setCreateTime(DateHelper.getTime());
        order.setLastUpdateTime(order.getCreateTime());
        order.setCreator(operator);
        order.setLastUpdator(order.getCreator());
        order.setProcessId(process.getId());
        ProcessModel model = process.getModel();
        if (model != null && args != null) {
            String orderNo;
            if (StringHelper.isNotEmpty(model.getExpireTime())) {
                String expireTime = DateHelper.parseTime(args.get(model.getExpireTime()));
                order.setExpireTime(expireTime);
            }
            if (StringHelper.isNotEmpty(orderNo = (String)args.get("snaker.orderNo"))) {
                order.setOrderNo(orderNo);
            } else {
                order.setOrderNo(model.getGenerator().generate(model));
            }
        }
        order.setVariable(JsonHelper.toJson(args));
        this.saveOrder(order);
        return order;
    }

    @Override
    public void addVariable(String orderId, Map<String, Object> args) {
        Order order = this.access().getOrder(orderId);
        Map<String, Object> data = order.getVariableMap();
        data.putAll(args);
        order.setVariable(JsonHelper.toJson(data));
        this.updateOrder(order);
    }

    @Override
    public void createCCOrder(String orderId, String ... actorIds) {
        for (String actorId : actorIds) {
            CCOrder ccorder = new CCOrder();
            ccorder.setOrderId(orderId);
            ccorder.setActorId(actorId);
            ccorder.setStatus(STATE_ACTIVE);
            this.access().saveCCOrder(ccorder);
        }
    }

    @Override
    public void saveOrder(Order order) {
        HistoryOrder history = new HistoryOrder(order);
        history.setOrderState(STATE_ACTIVE);
        this.access().saveOrder(order);
        this.access().saveHistory(history);
    }

    @Override
    public void updateOrder(Order order) {
        this.access().updateOrder(order);
    }

    @Override
    public void updateCCStatus(String orderId, String ... actorIds) {
        List<CCOrder> ccorders = this.access().getCCOrder(orderId, actorIds);
        AssertHelper.notNull(ccorders);
        for (CCOrder ccorder : ccorders) {
            ccorder.setStatus(STATE_FINISH);
            this.access().updateCCOrder(ccorder);
        }
    }

    @Override
    public void deleteCCOrder(String orderId, String actorId) {
        List<CCOrder> ccorders = this.access().getCCOrder(orderId, actorId);
        AssertHelper.notNull(ccorders);
        for (CCOrder ccorder : ccorders) {
            this.access().deleteCCOrder(ccorder);
        }
    }

    @Override
    public void complete(String orderId) {
        Order order = this.access().getOrder(orderId);
        HistoryOrder history = new HistoryOrder(order);
        history.setOrderState(STATE_FINISH);
        history.setEndTime(DateHelper.getTime());
        this.access().updateHistory(history);
        this.access().deleteOrder(order);
    }

    @Override
    public void terminate(String orderId) {
        this.terminate(orderId, null);
    }

    @Override
    public void terminate(String orderId, String operator) {
        SnakerEngine engine = ServiceContext.getEngine();
        List<Task> tasks = engine.query().getActiveTasks(new QueryFilter().setOrderId(orderId));
        for (Task task : tasks) {
            engine.task().complete(task.getId(), operator);
        }
        Order order = this.access().getOrder(orderId);
        HistoryOrder history = new HistoryOrder(order);
        history.setOrderState(STATE_TERMINATION);
        history.setEndTime(DateHelper.getTime());
        this.access().updateHistory(history);
        this.access().deleteOrder(order);
    }
}

