/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.snaker.engine.entity.Task;
import org.snaker.engine.helper.JsonHelper;
import org.snaker.engine.model.TaskModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryTask
implements Serializable {
    private static final long serialVersionUID = 6814632180050362450L;
    private String id;
    private String orderId;
    private String taskName;
    private String displayName;
    private Integer performType;
    private Integer taskType;
    private Integer taskState;
    private String operator;
    private String createTime;
    private String finishTime;
    private String expireTime;
    private String actionUrl;
    private String[] actorIds;
    private String parentTaskId;
    private String variable;

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public HistoryTask() {
    }

    public HistoryTask(Task task) {
        this.id = task.getId();
        this.orderId = task.getOrderId();
        this.createTime = task.getCreateTime();
        this.displayName = task.getDisplayName();
        this.taskName = task.getTaskName();
        this.taskType = task.getTaskType();
        this.expireTime = task.getExpireTime();
        this.actionUrl = task.getActionUrl();
        this.actorIds = task.getActorIds();
        this.parentTaskId = task.getParentTaskId();
        this.variable = task.getVariable();
        this.performType = task.getPerformType();
    }

    public Task undoTask() {
        Task task = new Task();
        task.setOrderId(this.getOrderId());
        task.setTaskName(this.getTaskName());
        task.setDisplayName(this.getDisplayName());
        task.setTaskType(this.getTaskType());
        task.setExpireTime(this.getExpireTime());
        task.setActionUrl(this.getActionUrl());
        task.setParentTaskId(this.getParentTaskId());
        task.setVariable(this.getVariable());
        task.setPerformType(this.getPerformType());
        task.setOperator(this.getOperator());
        return task;
    }

    public boolean isPerformAny() {
        return this.performType.intValue() == TaskModel.PerformType.ANY.ordinal();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getTaskState() {
        return this.taskState;
    }

    public void setTaskState(Integer taskState) {
        this.taskState = taskState;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getPerformType() {
        return this.performType;
    }

    public void setPerformType(Integer performType) {
        this.performType = performType;
    }

    public String[] getActorIds() {
        return this.actorIds;
    }

    public void setActorIds(String[] actorIds) {
        this.actorIds = actorIds;
    }

    public Map<String, Object> getVariableMap() {
        Map map = JsonHelper.fromJson(this.variable, Map.class);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryTask(id=").append(this.id);
        sb.append(",orderId=").append(this.orderId);
        sb.append(",taskName=").append(this.taskName);
        sb.append(",displayName").append(this.displayName);
        sb.append(",taskType=").append(this.taskType);
        sb.append(",createTime").append(this.createTime);
        sb.append(",performType=").append(this.performType).append(")");
        return sb.toString();
    }
}

