/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.impl;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerInterceptor;
import org.snaker.engine.core.Execution;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.Task;
import org.snaker.engine.model.TaskModel;
import org.snaker.engine.scheduling.IScheduler;
import org.snaker.engine.scheduling.JobEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerInterceptor
implements SnakerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SchedulerInterceptor.class);
    private IScheduler scheduler;
    private boolean isScheduled = true;

    @Override
    public void intercept(Execution execution) {
        if (!this.isScheduled) {
            return;
        }
        for (Task task : execution.getTasks()) {
            Date remindDate;
            String id = execution.getProcess().getId() + "-" + execution.getOrder().getId() + "-" + task.getId();
            Date expireDate = task.getExpireDate();
            if (expireDate != null) {
                this.schedule(id, task, expireDate, JobEntity.JobType.EXECUTER.ordinal(), execution.getArgs());
            }
            if ((remindDate = task.getRemindDate()) == null) continue;
            this.schedule(id, task, remindDate, JobEntity.JobType.REMINDER.ordinal(), execution.getArgs());
        }
    }

    public void schedule(String id, Task task, Date startDate, int jobType, Map<String, Object> args) {
        try {
            TaskModel model;
            JobEntity entity = new JobEntity(id, task, startDate, args);
            entity.setModelName(task.getTaskName());
            entity.setJobType(jobType);
            if (jobType == JobEntity.JobType.REMINDER.ordinal() && (model = (TaskModel)task.getModel()) != null && NumberUtils.isNumber((String)model.getReminderRepeat())) {
                entity.setPeriod(Integer.parseInt(model.getReminderRepeat()));
            }
            this.schedule(entity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.info("scheduler failed.task is:" + task);
        }
    }

    private void schedule(JobEntity entity) {
        if (this.scheduler == null) {
            this.scheduler = ServiceContext.getContext().find(IScheduler.class);
        }
        if (this.scheduler != null) {
            this.scheduler.schedule(entity);
        } else {
            this.isScheduled = false;
        }
    }
}

