/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.model;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.Action;
import org.snaker.engine.SnakerInterceptor;
import org.snaker.engine.core.Execution;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.BaseModel;
import org.snaker.engine.model.EndModel;
import org.snaker.engine.model.ForkModel;
import org.snaker.engine.model.JoinModel;
import org.snaker.engine.model.SubProcessModel;
import org.snaker.engine.model.TaskModel;
import org.snaker.engine.model.TransitionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeModel
extends BaseModel
implements Action {
    private static final long serialVersionUID = -2377317472320109317L;
    private static final Logger log = LoggerFactory.getLogger(NodeModel.class);
    private List<TransitionModel> inputs = new ArrayList<TransitionModel>();
    private List<TransitionModel> outputs = new ArrayList<TransitionModel>();
    private String layout;
    private String preInterceptors;
    private String postInterceptors;
    private List<SnakerInterceptor> preInterceptorList = new ArrayList<SnakerInterceptor>();
    private List<SnakerInterceptor> postInterceptorList = new ArrayList<SnakerInterceptor>();

    protected abstract void exec(Execution var1);

    @Override
    public void execute(Execution execution) {
        this.intercept(this.preInterceptorList, execution);
        this.exec(execution);
        this.intercept(this.postInterceptorList, execution);
    }

    protected void runOutTransition(Execution execution) {
        for (TransitionModel tm : this.getOutputs()) {
            tm.setEnabled(true);
            tm.execute(execution);
        }
    }

    private void intercept(List<SnakerInterceptor> interceptorList, Execution execution) {
        try {
            for (SnakerInterceptor interceptor : interceptorList) {
                interceptor.intercept(execution);
            }
        }
        catch (Exception e) {
            log.error("\u62e6\u622a\u5668\u6267\u884c\u5931\u8d25=" + e.getMessage());
        }
    }

    public boolean canRejected(NodeModel parent) {
        if (parent instanceof TaskModel && !((TaskModel)parent).isPerformAny()) {
            return false;
        }
        boolean result = false;
        for (TransitionModel tm : parent.getOutputs()) {
            NodeModel target = tm.getTarget();
            if (target.getName().equals(this.getName())) {
                return true;
            }
            if (target instanceof ForkModel || target instanceof JoinModel || target instanceof SubProcessModel || target instanceof EndModel) continue;
            result = result || this.canRejected(target);
        }
        return result;
    }

    public List<TransitionModel> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<TransitionModel> inputs) {
        this.inputs = inputs;
    }

    public List<TransitionModel> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<TransitionModel> outputs) {
        this.outputs = outputs;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getPreInterceptors() {
        return this.preInterceptors;
    }

    public void setPreInterceptors(String preInterceptors) {
        this.preInterceptors = preInterceptors;
        if (StringHelper.isNotEmpty(preInterceptors)) {
            for (String interceptor : preInterceptors.split(",")) {
                SnakerInterceptor instance = (SnakerInterceptor)ClassHelper.newInstance(interceptor);
                if (instance == null) continue;
                this.preInterceptorList.add(instance);
            }
        }
    }

    public String getPostInterceptors() {
        return this.postInterceptors;
    }

    public void setPostInterceptors(String postInterceptors) {
        this.postInterceptors = postInterceptors;
        if (StringHelper.isNotEmpty(postInterceptors)) {
            for (String interceptor : postInterceptors.split(",")) {
                SnakerInterceptor instance = (SnakerInterceptor)ClassHelper.newInstance(interceptor);
                if (instance == null) continue;
                this.postInterceptorList.add(instance);
            }
        }
    }
}

