/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.model;

import java.util.ArrayList;
import java.util.List;
import org.snaker.engine.INoGenerator;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.impl.DefaultNoGenerator;
import org.snaker.engine.model.BaseModel;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.StartModel;
import org.snaker.engine.model.WorkModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessModel
extends BaseModel {
    private static final long serialVersionUID = -9000210138346445915L;
    private List<NodeModel> nodes = new ArrayList<NodeModel>();
    private String instanceUrl;
    private String expireTime;
    private String instanceNoClass;
    private INoGenerator generator;

    public List<WorkModel> getWorkModels() {
        ArrayList<WorkModel> models = new ArrayList<WorkModel>();
        for (NodeModel node : this.nodes) {
            if (!(node instanceof WorkModel)) continue;
            models.add((WorkModel)node);
        }
        return models;
    }

    public StartModel getStart() {
        for (NodeModel node : this.nodes) {
            if (!(node instanceof StartModel)) continue;
            return (StartModel)node;
        }
        return null;
    }

    public NodeModel getNode(String nodeName) {
        for (NodeModel node : this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public <T> boolean containsNodeNames(Class<T> T, String ... nodeNames) {
        for (NodeModel node : this.nodes) {
            if (!T.isInstance(node)) continue;
            for (String nodeName : nodeNames) {
                if (!node.getName().equals(nodeName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<NodeModel> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NodeModel> nodes) {
        this.nodes = nodes;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public String getInstanceNoClass() {
        return this.instanceNoClass;
    }

    public void setInstanceNoClass(String instanceNoClass) {
        this.instanceNoClass = instanceNoClass;
        if (StringHelper.isNotEmpty(instanceNoClass)) {
            this.generator = (INoGenerator)ClassHelper.newInstance(instanceNoClass);
        }
    }

    public INoGenerator getGenerator() {
        return this.generator == null ? new DefaultNoGenerator() : this.generator;
    }

    public void setGenerator(INoGenerator generator) {
        this.generator = generator;
    }
}

