/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.model;

import java.util.ArrayList;
import java.util.List;
import org.snaker.engine.AssignmentHandler;
import org.snaker.engine.core.Execution;
import org.snaker.engine.handlers.impl.MergeActorHandler;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.FieldModel;
import org.snaker.engine.model.TransitionModel;
import org.snaker.engine.model.WorkModel;
import org.snaker.engine.scheduling.JobCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskModel
extends WorkModel {
    private static final long serialVersionUID = 1775545243233990922L;
    public static final String PERFORMTYPE_ANY = "ANY";
    public static final String PERFORMTYPE_ALL = "ALL";
    public static final String TASKTYPE_MAJOR = "Major";
    public static final String TASKTYPE_AIDANT = "Aidant";
    private String assignee;
    private String performType = "ANY";
    private String taskType = "Major";
    private String expireTime;
    private String reminderTime;
    private String reminderRepeat;
    private String autoExecute;
    private String callback;
    private String assignmentHandler;
    private JobCallback callbackObject;
    private AssignmentHandler assignmentHandlerObject;
    private List<FieldModel> fields = null;

    @Override
    protected void exec(Execution execution) {
        if (this.performType == null || this.performType.equalsIgnoreCase(PERFORMTYPE_ANY)) {
            this.runOutTransition(execution);
        } else {
            this.fire(new MergeActorHandler(this.getName()), execution);
            if (execution.isMerged()) {
                this.runOutTransition(execution);
            }
        }
    }

    public boolean isPerformAny() {
        return PERFORMTYPE_ANY.equalsIgnoreCase(this.performType);
    }

    public boolean isPerformAll() {
        return PERFORMTYPE_ALL.equalsIgnoreCase(this.performType);
    }

    public boolean isMajor() {
        return TASKTYPE_MAJOR.equalsIgnoreCase(this.taskType);
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = StringHelper.isEmpty(taskType) ? TASKTYPE_MAJOR : taskType;
    }

    public String getPerformType() {
        return this.performType;
    }

    public void setPerformType(String performType) {
        this.performType = StringHelper.isEmpty(performType) ? PERFORMTYPE_ANY : performType;
    }

    public String getReminderTime() {
        return this.reminderTime;
    }

    public void setReminderTime(String reminderTime) {
        this.reminderTime = reminderTime;
    }

    public String getReminderRepeat() {
        return this.reminderRepeat;
    }

    public void setReminderRepeat(String reminderRepeat) {
        this.reminderRepeat = reminderRepeat;
    }

    public String getAutoExecute() {
        return this.autoExecute;
    }

    public void setAutoExecute(String autoExecute) {
        this.autoExecute = autoExecute;
    }

    public AssignmentHandler getAssignmentHandlerObject() {
        return this.assignmentHandlerObject;
    }

    public void setAssignmentHandler(String assignmentHandlerStr) {
        if (StringHelper.isNotEmpty(assignmentHandlerStr)) {
            this.assignmentHandler = assignmentHandlerStr;
            this.assignmentHandlerObject = (AssignmentHandler)ClassHelper.newInstance(assignmentHandlerStr);
            AssertHelper.notNull(this.assignmentHandlerObject, "\u5206\u914d\u53c2\u4e0e\u8005\u5904\u7406\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25");
        }
    }

    public String getAssignmentHandler() {
        return this.assignmentHandler;
    }

    public String getCallback() {
        return this.callback;
    }

    public JobCallback getCallbackObject() {
        return this.callbackObject;
    }

    public void setCallback(String callbackStr) {
        if (StringHelper.isNotEmpty(callbackStr)) {
            this.callback = callbackStr;
            this.callbackObject = (JobCallback)ClassHelper.newInstance(callbackStr);
            AssertHelper.notNull(this.callbackObject, "\u56de\u8c03\u5904\u7406\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25");
        }
    }

    public List<FieldModel> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldModel> fields) {
        this.fields = fields;
    }

    public List<TaskModel> getNextTaskModels() {
        ArrayList<TaskModel> models = new ArrayList<TaskModel>();
        for (TransitionModel tm : this.getOutputs()) {
            this.addNextTaskModels(models, tm);
        }
        return models;
    }

    private void addNextTaskModels(List<TaskModel> models, TransitionModel tm) {
        if (tm.getTarget() instanceof TaskModel) {
            models.add((TaskModel)tm.getTarget());
        } else {
            for (TransitionModel tm2 : tm.getTarget().getOutputs()) {
                this.addNextTaskModels(models, tm2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskType {
        Major,
        Aidant;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PerformType {
        ANY,
        ALL;

    }
}

