/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;

public class ActionException
extends RuntimeException {
    private static final long serialVersionUID = 1998063243843477017L;
    private int errorCode;
    private Render errorRender;

    public ActionException(int errorCode, Render errorRender) {
        if (errorRender == null) {
            throw new IllegalArgumentException("The parameter errorRender can not be null.");
        }
        this.errorCode = errorCode;
        this.errorRender = errorRender;
    }

    public ActionException(int errorCode, String errorView) {
        if (StrKit.isBlank(errorView)) {
            throw new IllegalArgumentException("The parameter errorView can not be blank.");
        }
        this.errorCode = errorCode;
        this.errorRender = RenderFactory.me().getErrorRender(errorCode, errorView);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Render getErrorRender() {
        return this.errorRender;
    }
}

