/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.core.ActionException;
import com.jfinal.core.ActionRender;
import com.jfinal.core.Config;
import com.jfinal.core.ModelInjector;
import com.jfinal.core.TypeConverter;
import com.jfinal.i18n.I18N;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import com.jfinal.token.TokenManager;
import com.jfinal.upload.MultipartRequest;
import com.jfinal.upload.UploadFile;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String urlPara;
    private String[] urlParaArray;
    private static final String[] NULL_URL_PARA_ARRAY = new String[0];
    private static final String URL_PARA_SEPARATOR = Config.getConstants().getUrlParaSeparator();
    private static final RenderFactory renderFactory = RenderFactory.me();
    private Render render;

    void init(HttpServletRequest request, HttpServletResponse response, String urlPara) {
        this.request = request;
        this.response = response;
        this.urlPara = urlPara;
    }

    public void setUrlPara(String urlPara) {
        this.urlPara = urlPara;
        this.urlParaArray = null;
    }

    public Controller setAttr(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public Controller removeAttr(String name) {
        this.request.removeAttribute(name);
        return this;
    }

    public Controller setAttrs(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.request.setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getPara(String name) {
        return this.request.getParameter(name);
    }

    public String getPara(String name, String defaultValue) {
        String result = this.request.getParameter(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public Map<String, String[]> getParaMap() {
        return this.request.getParameterMap();
    }

    public Enumeration<String> getParaNames() {
        return this.request.getParameterNames();
    }

    public String[] getParaValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Integer[] getParaValuesToInt(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Integer.parseInt(values[i]);
            ++i;
        }
        return result;
    }

    public Enumeration<String> getAttrNames() {
        return this.request.getAttributeNames();
    }

    public <T> T getAttr(String name) {
        return (T)this.request.getAttribute(name);
    }

    public String getAttrForStr(String name) {
        return (String)this.request.getAttribute(name);
    }

    public Integer getAttrForInt(String name) {
        return (Integer)this.request.getAttribute(name);
    }

    private Integer toInt(String value, Integer defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Integer.parseInt(value.substring(1));
        }
        return Integer.parseInt(value);
    }

    public Integer getParaToInt(String name) {
        return this.toInt(this.request.getParameter(name), null);
    }

    public Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.request.getParameter(name), defaultValue);
    }

    private Long toLong(String value, Long defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Long.parseLong(value.substring(1));
        }
        return Long.parseLong(value);
    }

    public Long getParaToLong(String name) {
        return this.toLong(this.request.getParameter(name), null);
    }

    public Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.request.getParameter(name), defaultValue);
    }

    private Boolean toBoolean(String value, Boolean defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        if ("1".equals(value = value.trim().toLowerCase()) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("Can not parse the parameter \"" + value + "\" to boolean value.");
    }

    public Boolean getParaToBoolean(String name) {
        return this.toBoolean(this.request.getParameter(name), null);
    }

    public Boolean getParaToBoolean(String name, Boolean defaultValue) {
        return this.toBoolean(this.request.getParameter(name), defaultValue);
    }

    public Boolean getParaToBoolean() {
        return this.toBoolean(this.getPara(), null);
    }

    public Boolean getParaToBoolean(int index) {
        return this.toBoolean(this.getPara(index), null);
    }

    public Boolean getParaToBoolean(int index, Boolean defaultValue) {
        return this.toBoolean(this.getPara(index), defaultValue);
    }

    private Date toDate(String value, Date defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date getParaToDate(String name) {
        return this.toDate(this.request.getParameter(name), null);
    }

    public Date getParaToDate(String name, Date defaultValue) {
        return this.toDate(this.request.getParameter(name), defaultValue);
    }

    public Date getParaToDate() {
        return this.toDate(this.getPara(), null);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public <T> T getSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    public Controller setSessionAttr(String key, Object value) {
        this.request.getSession().setAttribute(key, value);
        return this;
    }

    public Controller removeSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public Integer getCookieToInt(String name) {
        String result = this.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    public Integer getCookieToInt(String name, Integer defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public Long getCookieToLong(String name) {
        String result = this.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    public Long getCookieToLong(String name, Long defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(name)) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public Cookie[] getCookieObjects() {
        Cookie[] result = this.request.getCookies();
        return result != null ? result : new Cookie[]{};
    }

    public Controller setCookie(Cookie cookie) {
        this.response.addCookie(cookie);
        return this;
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path) {
        this.setCookie(name, value, maxAgeInSeconds, path, null);
        return this;
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        this.response.addCookie(cookie);
        return this;
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds) {
        this.setCookie(name, value, maxAgeInSeconds, "/", null);
        return this;
    }

    public Controller removeCookie(String name) {
        this.setCookie(name, null, 0, "/", null);
        return this;
    }

    public Controller removeCookie(String name, String path) {
        this.setCookie(name, null, 0, path, null);
        return this;
    }

    public Controller removeCookie(String name, String path, String domain) {
        this.setCookie(name, null, 0, path, domain);
        return this;
    }

    public String getPara() {
        if ("".equals(this.urlPara)) {
            this.urlPara = null;
        }
        return this.urlPara;
    }

    public String getPara(int index) {
        if (index < 0) {
            return this.getPara();
        }
        if (this.urlParaArray == null) {
            this.urlParaArray = this.urlPara == null || "".equals(this.urlPara) ? NULL_URL_PARA_ARRAY : this.urlPara.split(URL_PARA_SEPARATOR);
            int i = 0;
            while (i < this.urlParaArray.length) {
                if ("".equals(this.urlParaArray[i])) {
                    this.urlParaArray[i] = null;
                }
                ++i;
            }
        }
        return this.urlParaArray.length > index ? this.urlParaArray[index] : null;
    }

    public String getPara(int index, String defaultValue) {
        String result = this.getPara(index);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public Integer getParaToInt(int index) {
        return this.toInt(this.getPara(index), null);
    }

    public Integer getParaToInt(int index, Integer defaultValue) {
        return this.toInt(this.getPara(index), defaultValue);
    }

    public Long getParaToLong(int index) {
        return this.toLong(this.getPara(index), null);
    }

    public Long getParaToLong(int index, Long defaultValue) {
        return this.toLong(this.getPara(index), defaultValue);
    }

    public Integer getParaToInt() {
        return this.toInt(this.getPara(), null);
    }

    public Long getParaToLong() {
        return this.toLong(this.getPara(), null);
    }

    public <T> T getModel(Class<T> modelClass) {
        return ModelInjector.inject(modelClass, this.request, false);
    }

    public <T> T getModel(Class<T> modelClass, String modelName) {
        return ModelInjector.inject(modelClass, modelName, this.request, false);
    }

    public List<UploadFile> getFiles(String saveDirectory, Integer maxPostSize, String encoding) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, saveDirectory, maxPostSize, encoding);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String saveDirectory, Integer maxPostSize, String encoding) {
        this.getFiles(saveDirectory, maxPostSize, encoding);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String saveDirectory, int maxPostSize) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, saveDirectory, maxPostSize);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String saveDirectory, int maxPostSize) {
        this.getFiles(saveDirectory, maxPostSize);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String saveDirectory) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, saveDirectory);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String saveDirectory) {
        this.getFiles(saveDirectory);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles() {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile() {
        List<UploadFile> uploadFiles = this.getFiles();
        return uploadFiles.size() > 0 ? uploadFiles.get(0) : null;
    }

    public UploadFile getFile(String parameterName) {
        List<UploadFile> uploadFiles = this.getFiles();
        for (UploadFile uploadFile : uploadFiles) {
            if (!uploadFile.getParameterName().equals(parameterName)) continue;
            return uploadFile;
        }
        return null;
    }

    public Controller setLocaleToCookie(Locale locale) {
        this.setCookie("__I18N_LOCALE__", locale.toString(), I18N.getI18nMaxAgeOfCookie());
        return this;
    }

    public Controller setLocaleToCookie(Locale locale, int maxAge) {
        this.setCookie("__I18N_LOCALE__", locale.toString(), maxAge);
        return this;
    }

    public String getText(String key) {
        return I18N.getText(key, this.getLocaleFromCookie());
    }

    public String getText(String key, String defaultValue) {
        return I18N.getText(key, defaultValue, this.getLocaleFromCookie());
    }

    private Locale getLocaleFromCookie() {
        Cookie cookie = this.getCookieObject("__I18N_LOCALE__");
        if (cookie != null) {
            return I18N.localeFromString(cookie.getValue());
        }
        Locale defaultLocale = I18N.getDefaultLocale();
        this.setLocaleToCookie(defaultLocale);
        return I18N.localeFromString(defaultLocale.toString());
    }

    public Controller keepPara() {
        Map map = this.request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            String[] values = (String[])e.getValue();
            if (values.length == 1) {
                this.request.setAttribute((String)e.getKey(), (Object)values[0]);
                continue;
            }
            this.request.setAttribute((String)e.getKey(), (Object)values);
        }
        return this;
    }

    public Controller keepPara(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String[] values = this.request.getParameterValues(name);
            if (values != null) {
                if (values.length == 1) {
                    this.request.setAttribute(name, (Object)values[0]);
                } else {
                    this.request.setAttribute(name, (Object)values);
                }
            }
            ++n2;
        }
        return this;
    }

    public Controller keepPara(Class type, String name) {
        String[] values = this.request.getParameterValues(name);
        if (values != null) {
            if (values.length == 1) {
                try {
                    this.request.setAttribute(name, TypeConverter.convert(type, values[0]));
                }
                catch (ParseException parseException) {}
            } else {
                this.request.setAttribute(name, (Object)values);
            }
        }
        return this;
    }

    public Controller keepPara(Class type, String ... names) {
        if (type == String.class) {
            return this.keepPara(names);
        }
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.keepPara(type, name);
                ++n2;
            }
        }
        return this;
    }

    public Controller keepModel(Class modelClass, String modelName) {
        Object model = ModelInjector.inject(modelClass, modelName, this.request, true);
        this.request.setAttribute(modelName, model);
        return this;
    }

    public Controller keepModel(Class modelClass) {
        String modelName = StrKit.firstCharToLowerCase(modelClass.getSimpleName());
        this.keepModel(modelClass, modelName);
        return this;
    }

    public void createToken(String tokenName, int secondsOfTimeOut) {
        TokenManager.createToken(this, tokenName, secondsOfTimeOut);
    }

    public void createToken() {
        this.createToken("jfinal_token", 900);
    }

    public void createToken(String tokenName) {
        this.createToken(tokenName, 900);
    }

    public boolean validateToken(String tokenName) {
        return TokenManager.validateToken(this, tokenName);
    }

    public boolean validateToken() {
        return this.validateToken("jfinal_token");
    }

    public boolean isParaBlank(String paraName) {
        String value = this.request.getParameter(paraName);
        return value == null || value.trim().length() == 0;
    }

    public boolean isParaBlank(int index) {
        String value = this.getPara(index);
        return value == null || value.trim().length() == 0;
    }

    public boolean isParaExists(String paraName) {
        return this.request.getParameterMap().containsKey(paraName);
    }

    public boolean isParaExists(int index) {
        return this.getPara(index) != null;
    }

    public Render getRender() {
        return this.render;
    }

    public void render(Render render) {
        this.render = render;
    }

    public void render(String view) {
        this.render = renderFactory.getRender(view);
    }

    public void renderJsp(String view) {
        this.render = renderFactory.getJspRender(view);
    }

    public void renderFreeMarker(String view) {
        this.render = renderFactory.getFreeMarkerRender(view);
    }

    public void renderVelocity(String view) {
        this.render = renderFactory.getVelocityRender(view);
    }

    public void renderJson(String key, Object value) {
        this.render = renderFactory.getJsonRender(key, value);
    }

    public void renderJson() {
        this.render = renderFactory.getJsonRender();
    }

    public void renderJson(String[] attrs) {
        this.render = renderFactory.getJsonRender(attrs);
    }

    public void renderJson(String jsonText) {
        this.render = renderFactory.getJsonRender(jsonText);
    }

    public void renderJson(Object object) {
        this.render = renderFactory.getJsonRender(object);
    }

    public void renderText(String text) {
        this.render = renderFactory.getTextRender(text);
    }

    public void renderText(String text, String contentType) {
        this.render = renderFactory.getTextRender(text, contentType);
    }

    public void forwardAction(String actionUrl) {
        this.render = new ActionRender(actionUrl);
    }

    public void renderFile(String fileName) {
        this.render = renderFactory.getFileRender(fileName);
    }

    public void renderFile(File file) {
        this.render = renderFactory.getFileRender(file);
    }

    public void redirect(String url) {
        this.render = renderFactory.getRedirectRender(url);
    }

    public void redirect(String url, boolean withQueryString) {
        this.render = renderFactory.getRedirectRender(url, withQueryString);
    }

    public void render(String view, int status) {
        this.render = renderFactory.getRender(view);
        this.response.setStatus(status);
    }

    public void redirect301(String url) {
        this.render = renderFactory.getRedirect301Render(url);
    }

    public void redirect301(String url, boolean withQueryString) {
        this.render = renderFactory.getRedirect301Render(url, withQueryString);
    }

    public void renderError(int errorCode, String view) {
        throw new ActionException(errorCode, renderFactory.getErrorRender(errorCode, view));
    }

    public void renderError(int errorCode, Render render) {
        throw new ActionException(errorCode, render);
    }

    public void renderError(int errorCode) {
        throw new ActionException(errorCode, renderFactory.getErrorRender(errorCode));
    }

    public void renderNull() {
        this.render = renderFactory.getNullRender();
    }

    public void renderJavascript(String javascriptText) {
        this.render = renderFactory.getJavascriptRender(javascriptText);
    }

    public void renderHtml(String htmlText) {
        this.render = renderFactory.getHtmlRender(htmlText);
    }
}

