/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.alibaba.druid.util.DruidWebUtils;
import com.alibaba.druid.util.PatternMatcher;
import com.alibaba.druid.util.ServletPathMatcher;
import com.jfinal.config.Constants;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Config;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.log.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JFinalFilter
implements Filter {
    private Handler handler;
    private String encoding;
    private JFinalConfig jfinalConfig;
    private Constants constants;
    private static final JFinal jfinal = JFinal.me();
    private static Logger log;
    private int contextPathLength;
    protected String contextPath;
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";
    protected PatternMatcher pathMatcher = new ServletPathMatcher();
    private Set<String> excludesPattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contextPath = DruidWebUtils.getContextPath((ServletContext)filterConfig.getServletContext());
        this.createJFinalConfig(filterConfig.getInitParameter("configClass"));
        String exclusions = filterConfig.getInitParameter(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        if (!jfinal.init(this.jfinalConfig, filterConfig.getServletContext())) {
            throw new RuntimeException("JFinal init error!");
        }
        this.handler = jfinal.getHandler();
        this.constants = Config.getConstants();
        this.encoding = this.constants.getEncoding();
        this.jfinalConfig.afterJFinalStart();
        String contextPath = filterConfig.getServletContext().getContextPath();
        this.contextPathLength = contextPath == null || "/".equals(contextPath) ? 0 : contextPath.length();
    }

    public boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null) {
            return false;
        }
        if (this.contextPath != null && requestURI.startsWith(this.contextPath) && !(requestURI = requestURI.substring(this.contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : this.excludesPattern) {
            if (!this.pathMatcher.matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean[] isHandled;
        HttpServletResponse response;
        HttpServletRequest request;
        block5: {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
            request.setCharacterEncoding(this.encoding);
            String requestURI = request.getRequestURI();
            if (this.isExclusion(requestURI)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String target = request.getRequestURI();
            if (this.contextPathLength != 0) {
                target = target.substring(this.contextPathLength);
            }
            isHandled = new boolean[1];
            try {
                this.handler.handle(target, request, response, isHandled);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                String qs = request.getQueryString();
                log.error(qs == null ? target : String.valueOf(target) + "?" + qs, e);
            }
        }
        if (!isHandled[0]) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
        this.jfinalConfig.beforeJFinalStop();
        jfinal.stopPlugins();
    }

    private void createJFinalConfig(String configClass) {
        if (configClass == null) {
            throw new RuntimeException("Please set configClass parameter of JFinalFilter in web.xml");
        }
        try {
            Object temp = Class.forName(configClass).newInstance();
            if (!(temp instanceof JFinalConfig)) {
                throw new RuntimeException("Can not create instance of class: " + configClass + ". Please check the config in web.xml");
            }
            this.jfinalConfig = (JFinalConfig)temp;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can not create instance of class: " + configClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can not create instance of class: " + configClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + configClass + ". Please config it in web.xml", e);
        }
    }

    static void initLogger() {
        log = Logger.getLogger(JFinalFilter.class);
    }
}

